/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.member;

import java.util.Map;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.OperatorType;
import org.openzen.zenscript.codemodel.context.TypeResolutionContext;
import org.openzen.zenscript.codemodel.member.IDefinitionMember;
import org.openzen.zenscript.codemodel.scope.BaseScope;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;
import org.openzen.zenscript.parser.ParsedAnnotation;
import org.openzen.zenscript.parser.ParsedDefinition;
import org.openzen.zenscript.parser.PrecompilationState;
import org.openzen.zenscript.parser.definitions.ParsedFunctionHeader;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.member.ParsedCaller;
import org.openzen.zenscript.parser.member.ParsedCaster;
import org.openzen.zenscript.parser.member.ParsedConst;
import org.openzen.zenscript.parser.member.ParsedConstructor;
import org.openzen.zenscript.parser.member.ParsedDestructor;
import org.openzen.zenscript.parser.member.ParsedField;
import org.openzen.zenscript.parser.member.ParsedGetter;
import org.openzen.zenscript.parser.member.ParsedImplementation;
import org.openzen.zenscript.parser.member.ParsedInnerDefinition;
import org.openzen.zenscript.parser.member.ParsedIterator;
import org.openzen.zenscript.parser.member.ParsedMethod;
import org.openzen.zenscript.parser.member.ParsedOperator;
import org.openzen.zenscript.parser.member.ParsedSetter;
import org.openzen.zenscript.parser.member.ParsedStaticInitializer;
import org.openzen.zenscript.parser.statements.ParsedFunctionBody;
import org.openzen.zenscript.parser.statements.ParsedStatement;
import org.openzen.zenscript.parser.statements.ParsedStatementBlock;
import org.openzen.zenscript.parser.type.IParsedType;
import org.openzen.zenscript.parser.type.ParsedTypeBasic;

public abstract class ParsedDefinitionMember {
    public final HighLevelDefinition definition;
    public final ParsedAnnotation[] annotations;

    public ParsedDefinitionMember(HighLevelDefinition definition, ParsedAnnotation[] annotations) {
        this.definition = definition;
        this.annotations = annotations;
    }

    public static ParsedDefinitionMember parse(ZSTokenParser tokens, ParsedDefinition forDefinition, ParsedImplementation forImplementation) throws ParseException {
        CodePosition start = tokens.getPosition();
        ParsedAnnotation[] annotations = ParsedAnnotation.parseAnnotations(tokens);
        int modifiers = 0;
        block30: while (true) {
            switch (((ZSToken)tokens.peek()).type) {
                case K_INTERNAL: {
                    tokens.next();
                    modifiers |= 2;
                    continue block30;
                }
                case K_PUBLIC: {
                    tokens.next();
                    modifiers |= 1;
                    continue block30;
                }
                case K_PRIVATE: {
                    tokens.next();
                    modifiers |= 4;
                    continue block30;
                }
                case K_CONST: {
                    tokens.next();
                    if (tokens.optional(ZSTokenType.T_QUEST) != null) {
                        modifiers |= 0x40;
                        continue block30;
                    }
                    modifiers |= 0x20;
                    continue block30;
                }
                case K_ABSTRACT: {
                    tokens.next();
                    modifiers |= 8;
                    continue block30;
                }
                case K_FINAL: {
                    tokens.next();
                    modifiers |= 0x10;
                    continue block30;
                }
                case K_STATIC: {
                    tokens.next();
                    modifiers |= 0x80;
                    continue block30;
                }
                case K_PROTECTED: {
                    tokens.next();
                    modifiers |= 0x100;
                    continue block30;
                }
                case K_IMPLICIT: {
                    tokens.next();
                    modifiers |= 0x200;
                    continue block30;
                }
                case K_EXTERN: {
                    tokens.next();
                    modifiers |= 0x800;
                    continue block30;
                }
                case K_OVERRIDE: {
                    tokens.next();
                    modifiers |= 0x1000;
                    continue block30;
                }
            }
            break;
        }
        switch (((ZSToken)tokens.peek()).type) {
            case K_VAL: 
            case K_VAR: {
                ZSToken t = (ZSToken)tokens.next();
                String name = ((ZSToken)tokens.required(ZSTokenType.T_IDENTIFIER, (String)"identifier expected")).content;
                IParsedType type = ParsedTypeBasic.UNDETERMINED;
                if (tokens.optional(ZSTokenType.K_AS) != null) {
                    type = IParsedType.parse(tokens);
                }
                ParsedExpression initializer = null;
                int autoGetter = 0;
                int autoSetter = 0;
                if (tokens.optional(ZSTokenType.T_COLON) != null) {
                    do {
                        int accessor = 1;
                        if (tokens.optional(ZSTokenType.K_PUBLIC) != null) {
                            accessor = 1;
                        } else if (tokens.optional(ZSTokenType.K_PROTECTED) != null) {
                            accessor = 256;
                        }
                        if (tokens.optional(ZSTokenType.K_GET) != null) {
                            autoGetter = accessor;
                            continue;
                        }
                        tokens.required(ZSTokenType.K_SET, "get or set expected");
                        autoSetter = accessor;
                    } while (tokens.optional(ZSTokenType.T_COMMA) != null);
                }
                if (tokens.optional(ZSTokenType.T_ASSIGN) != null) {
                    initializer = ParsedExpression.parse(tokens);
                }
                tokens.required(ZSTokenType.T_SEMICOLON, "; expected");
                return new ParsedField(start, forDefinition.getCompiled(), modifiers, annotations, name, type, initializer, t.type == ZSTokenType.K_VAL, autoGetter, autoSetter);
            }
            case K_THIS: {
                tokens.next();
                ParsedFunctionHeader header = ParsedFunctionHeader.parse(tokens);
                ParsedFunctionBody body = ParsedStatement.parseFunctionBody(tokens);
                if (body == null) {
                    throw new ParseException(start, "Function body is required for constructors");
                }
                return new ParsedConstructor(start, forDefinition.getCompiled(), forImplementation, modifiers, annotations, header, body);
            }
            case T_IDENTIFIER: {
                String name = ((ZSToken)tokens.next()).content;
                if ((modifiers & 0x20) == 32 && (tokens.isNext(ZSTokenType.K_AS) || tokens.isNext(ZSTokenType.T_ASSIGN))) {
                    IParsedType type = ParsedTypeBasic.UNDETERMINED;
                    if (tokens.optional(ZSTokenType.K_AS) != null) {
                        type = IParsedType.parse(tokens);
                    }
                    tokens.required(ZSTokenType.T_ASSIGN, "= expected");
                    ParsedExpression value = ParsedExpression.parse(tokens);
                    tokens.required(ZSTokenType.T_SEMICOLON, "; expected");
                    return new ParsedConst(start, forDefinition.getCompiled(), modifiers & 0xFFFFFFDF, annotations, name, type, value);
                }
                ParsedFunctionHeader header = ParsedFunctionHeader.parse(tokens);
                ParsedFunctionBody body = ParsedStatement.parseFunctionBody(tokens);
                return new ParsedMethod(start, forDefinition.getCompiled(), forImplementation, modifiers, annotations, name, header, body);
            }
            case K_SET: {
                tokens.next();
                String name = ((ZSToken)tokens.required(ZSTokenType.T_IDENTIFIER, (String)"identifier expected")).content;
                IParsedType type = ParsedTypeBasic.UNDETERMINED;
                if (tokens.optional(ZSTokenType.K_AS) != null) {
                    type = IParsedType.parse(tokens);
                }
                ParsedFunctionBody body = ParsedStatement.parseFunctionBody(tokens);
                return new ParsedSetter(start, forDefinition.getCompiled(), forImplementation, modifiers, annotations, name, type, body);
            }
            case K_GET: {
                tokens.next();
                String name = ((ZSToken)tokens.required(ZSTokenType.T_IDENTIFIER, (String)"identifier expected")).content;
                IParsedType type = ParsedTypeBasic.UNDETERMINED;
                if (tokens.optional(ZSTokenType.K_AS) != null) {
                    type = IParsedType.parse(tokens);
                }
                ParsedFunctionBody statements = ParsedStatement.parseFunctionBody(tokens);
                return new ParsedGetter(start, forDefinition.getCompiled(), forImplementation, modifiers, annotations, name, type, statements);
            }
            case K_IMPLEMENTS: {
                tokens.next();
                IParsedType type = IParsedType.parse(tokens);
                ParsedImplementation implementation = new ParsedImplementation(start, forDefinition.getCompiled(), modifiers, annotations, type);
                if (tokens.optional(ZSTokenType.T_SEMICOLON) == null) {
                    tokens.required(ZSTokenType.T_AOPEN, "{ expected");
                    while (tokens.optional(ZSTokenType.T_ACLOSE) == null) {
                        implementation.addMember(ParsedDefinitionMember.parse(tokens, forDefinition, implementation));
                    }
                }
                return implementation;
            }
            case T_BROPEN: {
                ParsedFunctionHeader header = ParsedFunctionHeader.parse(tokens);
                ParsedFunctionBody body = ParsedStatement.parseFunctionBody(tokens);
                return new ParsedCaller(start, forDefinition.getCompiled(), forImplementation, modifiers, annotations, header, body);
            }
            case T_SQOPEN: {
                tokens.next();
                tokens.required(ZSTokenType.T_SQCLOSE, "] expected");
                OperatorType operator = OperatorType.INDEXGET;
                if (tokens.optional(ZSTokenType.T_ASSIGN) != null) {
                    operator = OperatorType.INDEXSET;
                }
                ParsedFunctionHeader header = ParsedFunctionHeader.parse(tokens);
                ParsedFunctionBody body = ParsedStatement.parseFunctionBody(tokens);
                return new ParsedOperator(start, forDefinition.getCompiled(), forImplementation, modifiers, annotations, operator, header, body);
            }
            case T_CAT: {
                tokens.pushMark();
                tokens.next();
                if (tokens.optional(ZSTokenType.K_THIS) != null) {
                    tokens.popMark();
                    ParsedFunctionBody body = ParsedStatement.parseFunctionBody(tokens);
                    return new ParsedDestructor(start, forDefinition.getCompiled(), forImplementation, modifiers, annotations, body);
                }
                tokens.reset();
            }
            case T_ADD: 
            case T_SUB: 
            case T_MUL: 
            case T_DIV: 
            case T_MOD: 
            case T_AND: 
            case T_OR: 
            case T_XOR: 
            case T_NOT: 
            case T_ADDASSIGN: 
            case T_SUBASSIGN: 
            case T_CATASSIGN: 
            case T_MULASSIGN: 
            case T_DIVASSIGN: 
            case T_MODASSIGN: 
            case T_ANDASSIGN: 
            case T_ORASSIGN: 
            case T_XORASSIGN: 
            case T_INCREMENT: 
            case T_DECREMENT: 
            case T_DOT2: 
            case T_SHL: 
            case T_SHR: 
            case T_USHR: 
            case T_SHLASSIGN: 
            case T_SHRASSIGN: 
            case T_USHRASSIGN: {
                ZSToken token = (ZSToken)tokens.next();
                ParsedFunctionHeader header = ParsedFunctionHeader.parse(tokens);
                ParsedFunctionBody body = ParsedStatement.parseFunctionBody(tokens);
                return new ParsedOperator(start, forDefinition.getCompiled(), forImplementation, modifiers, annotations, ParsedDefinitionMember.getOperator(token.type), header, body);
            }
            case T_EQUAL2: {
                tokens.next();
                ParsedFunctionHeader header = ParsedFunctionHeader.parse(tokens);
                ParsedFunctionBody body = ParsedStatement.parseFunctionBody(tokens);
                return new ParsedOperator(start, forDefinition.getCompiled(), forImplementation, modifiers, annotations, OperatorType.EQUALS, header, body);
            }
            case K_AS: {
                tokens.next();
                IParsedType type = IParsedType.parse(tokens);
                ParsedFunctionBody body = ParsedStatement.parseFunctionBody(tokens);
                return new ParsedCaster(start, forDefinition.getCompiled(), forImplementation, modifiers, annotations, type, body);
            }
            case K_IN: {
                tokens.next();
                ParsedFunctionHeader header = ParsedFunctionHeader.parse(tokens);
                ParsedFunctionBody body = ParsedStatement.parseFunctionBody(tokens);
                return new ParsedOperator(start, forDefinition.getCompiled(), forImplementation, modifiers, annotations, OperatorType.CONTAINS, header, body);
            }
            case K_CLASS: 
            case K_INTERFACE: 
            case K_ALIAS: 
            case K_STRUCT: 
            case K_ENUM: {
                return new ParsedInnerDefinition(forDefinition.getCompiled(), ParsedDefinition.parse(forDefinition.pkg, start, modifiers, annotations, tokens, forDefinition.getCompiled()));
            }
            case K_FOR: {
                tokens.next();
                ParsedFunctionHeader header = ParsedFunctionHeader.parse(tokens);
                ParsedFunctionBody body = ParsedStatement.parseFunctionBody(tokens);
                return new ParsedIterator(start, forDefinition.getCompiled(), modifiers, annotations, header, body);
            }
        }
        if (modifiers == 128 && ((ZSToken)tokens.peek()).type == ZSTokenType.T_AOPEN) {
            ParsedStatementBlock body = ParsedStatementBlock.parseBlock(tokens, annotations, true);
            return new ParsedStaticInitializer(forDefinition.getCompiled(), tokens.getPosition(), annotations, body);
        }
        throw new ParseException(tokens.getPosition(), "Unexpected token: " + ((ZSToken)tokens.peek()).content);
    }

    private static OperatorType getOperator(ZSTokenType type) {
        switch (type) {
            case T_ADD: {
                return OperatorType.ADD;
            }
            case T_SUB: {
                return OperatorType.SUB;
            }
            case T_CAT: {
                return OperatorType.CAT;
            }
            case T_MUL: {
                return OperatorType.MUL;
            }
            case T_DIV: {
                return OperatorType.DIV;
            }
            case T_MOD: {
                return OperatorType.MOD;
            }
            case T_AND: {
                return OperatorType.AND;
            }
            case T_OR: {
                return OperatorType.OR;
            }
            case T_XOR: {
                return OperatorType.XOR;
            }
            case T_NOT: {
                return OperatorType.NOT;
            }
            case T_ADDASSIGN: {
                return OperatorType.ADDASSIGN;
            }
            case T_SUBASSIGN: {
                return OperatorType.SUBASSIGN;
            }
            case T_CATASSIGN: {
                return OperatorType.CATASSIGN;
            }
            case T_MULASSIGN: {
                return OperatorType.MULASSIGN;
            }
            case T_DIVASSIGN: {
                return OperatorType.DIVASSIGN;
            }
            case T_MODASSIGN: {
                return OperatorType.MODASSIGN;
            }
            case T_ANDASSIGN: {
                return OperatorType.ANDASSIGN;
            }
            case T_ORASSIGN: {
                return OperatorType.ORASSIGN;
            }
            case T_XORASSIGN: {
                return OperatorType.XORASSIGN;
            }
            case T_INCREMENT: {
                return OperatorType.INCREMENT;
            }
            case T_DECREMENT: {
                return OperatorType.DECREMENT;
            }
            case T_DOT2: {
                return OperatorType.RANGE;
            }
            case T_SHL: {
                return OperatorType.SHL;
            }
            case T_SHR: {
                return OperatorType.SHR;
            }
            case T_USHR: {
                return OperatorType.USHR;
            }
            case T_SHLASSIGN: {
                return OperatorType.SHLASSIGN;
            }
            case T_SHRASSIGN: {
                return OperatorType.SHRASSIGN;
            }
            case T_USHRASSIGN: {
                return OperatorType.USHRASSIGN;
            }
        }
        throw new AssertionError((Object)"Missing switch case in getOperator");
    }

    public abstract void linkTypes(TypeResolutionContext var1);

    public void registerInnerTypes(Map<String, ParsedDefinition> innerTypes) {
    }

    public abstract IDefinitionMember getCompiled();

    public abstract void compile(BaseScope var1) throws CompileException;

    public void registerMembers(BaseScope scope, PrecompilationState state) {
    }
}

