/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javashared;

import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.AssocTypeID;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.FunctionTypeID;
import org.openzen.zenscript.codemodel.type.GenericMapTypeID;
import org.openzen.zenscript.codemodel.type.GenericTypeID;
import org.openzen.zenscript.codemodel.type.IteratorTypeID;
import org.openzen.zenscript.codemodel.type.OptionalTypeID;
import org.openzen.zenscript.codemodel.type.RangeTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.TypeVisitor;

public class JavaTypeNameVisitor
implements TypeVisitor<String> {
    public static final JavaTypeNameVisitor INSTANCE = new JavaTypeNameVisitor();

    private JavaTypeNameVisitor() {
    }

    public String process(TypeID type) {
        return type.accept(this);
    }

    @Override
    public String visitBasic(BasicTypeID basic) {
        switch (basic) {
            case VOID: {
                return "Void";
            }
            case BOOL: {
                return "Bool";
            }
            case BYTE: {
                return "Byte";
            }
            case SBYTE: {
                return "SByte";
            }
            case SHORT: {
                return "Short";
            }
            case USHORT: {
                return "UShort";
            }
            case INT: {
                return "Int";
            }
            case UINT: {
                return "UInt";
            }
            case LONG: {
                return "Long";
            }
            case ULONG: {
                return "ULong";
            }
            case FLOAT: {
                return "Float";
            }
            case DOUBLE: {
                return "Double";
            }
            case CHAR: {
                return "Char";
            }
            case STRING: {
                return "String";
            }
        }
        throw new IllegalArgumentException("Invalid type: " + String.valueOf(basic));
    }

    @Override
    public String visitArray(ArrayTypeID array) {
        if (array.dimension == 1) {
            return this.process(array.elementType) + "Array";
        }
        return this.process(array.elementType) + array.dimension + "DArray";
    }

    @Override
    public String visitAssoc(AssocTypeID assoc) {
        return this.process(assoc.keyType) + this.process(assoc.valueType) + "Map";
    }

    @Override
    public String visitGenericMap(GenericMapTypeID map) {
        return "GenericMap";
    }

    @Override
    public String visitIterator(IteratorTypeID iterator) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String visitFunction(FunctionTypeID function) {
        StringBuilder result = new StringBuilder();
        for (FunctionParameter parameter : function.header.parameters) {
            result.append(this.process(parameter.type));
        }
        result.append("To");
        result.append(this.process(function.header.getReturnType()));
        result.append("Function");
        return result.toString();
    }

    @Override
    public String visitDefinition(DefinitionTypeID definition) {
        return definition.definition.name;
    }

    @Override
    public String visitGeneric(GenericTypeID generic) {
        return generic.parameter.name;
    }

    @Override
    public String visitRange(RangeTypeID range) {
        return range.baseType.accept(this) + "Range";
    }

    @Override
    public String visitOptional(OptionalTypeID type) {
        StringBuilder result = new StringBuilder();
        if (type.isOptional()) {
            result.append("Optional");
        }
        result.append(type.baseType.accept(this));
        return result.toString();
    }
}

