/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import java.util.ArrayList;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.ConstantStringExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.expression.PanicExpression;
import org.openzen.zenscript.codemodel.expression.SetLocalVariableExpression;
import org.openzen.zenscript.codemodel.expression.ThrowExpression;
import org.openzen.zenscript.codemodel.expression.switchvalue.SwitchValue;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.statement.BreakStatement;
import org.openzen.zenscript.codemodel.statement.ExpressionStatement;
import org.openzen.zenscript.codemodel.statement.Statement;
import org.openzen.zenscript.codemodel.statement.SwitchCase;
import org.openzen.zenscript.codemodel.statement.SwitchStatement;
import org.openzen.zenscript.codemodel.statement.VarStatement;
import org.openzen.zenscript.codemodel.statement.VariableID;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;

public class MatchExpression
extends Expression {
    public final Expression value;
    public final Case[] cases;

    public MatchExpression(CodePosition position, Expression value, TypeID type, Case[] cases) {
        super(position, type, MatchExpression.binaryThrow(position, value.thrownType, MatchExpression.getThrownType(position, cases)));
        this.value = value;
        this.cases = cases;
    }

    private static TypeID getThrownType(CodePosition position, Case[] cases) {
        if (cases.length == 0) {
            return null;
        }
        TypeID result = cases[0].value.thrownType;
        for (int i = 1; i < cases.length; ++i) {
            result = MatchExpression.binaryThrow(position, result, cases[i].value.thrownType);
        }
        return result;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitMatch(this);
    }

    @Override
    public <C, R> R accept(C context, ExpressionVisitorWithContext<C, R> visitor) {
        return visitor.visitMatch(context, this);
    }

    @Override
    public Expression transform(ExpressionTransformer transformer) {
        Expression tValue = this.value.transform(transformer);
        Case[] tCases = new Case[this.cases.length];
        boolean unmodified = true;
        for (int i = 0; i < tCases.length; ++i) {
            tCases[i] = this.cases[i].transform(transformer);
            unmodified &= tCases[i] == this.cases[i];
        }
        return unmodified && tValue == this.value ? this : new MatchExpression(this.position, tValue, this.type, tCases);
    }

    @Override
    public Expression normalize(TypeScope scope) {
        Case[] normalizedCases = new Case[this.cases.length];
        for (int i = 0; i < this.cases.length; ++i) {
            normalizedCases[i] = this.cases[i].normalize(scope);
        }
        return new MatchExpression(this.position, this.value.normalize(scope), this.type, normalizedCases);
    }

    public SwitchedMatch convertToSwitch(String tempVariable) {
        VarStatement result = new VarStatement(this.position, new VariableID(), tempVariable, this.type, null, false);
        SwitchStatement switchStatement = new SwitchStatement(this.position, null, this.value);
        boolean hasDefault = false;
        for (Case matchCase : this.cases) {
            Expression caseExpression;
            boolean reachable = true;
            if (matchCase.value instanceof ThrowExpression || matchCase.value instanceof PanicExpression) {
                caseExpression = matchCase.value;
                reachable = false;
            } else {
                caseExpression = new SetLocalVariableExpression(matchCase.value.position, result, matchCase.value);
            }
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.add(new ExpressionStatement(matchCase.value.position, caseExpression));
            if (reachable) {
                statements.add(new BreakStatement(matchCase.value.position, switchStatement));
            }
            SwitchCase switchCase = new SwitchCase(matchCase.key, statements.toArray(new Statement[statements.size()]));
            switchStatement.cases.add(switchCase);
            if (matchCase.key != null) continue;
            hasDefault = true;
        }
        if (!hasDefault) {
            ExpressionStatement defaultCase = new ExpressionStatement(this.position, new PanicExpression(this.position, (TypeID)BasicTypeID.VOID, new ConstantStringExpression(this.position, "Missing case")));
            switchStatement.cases.add(new SwitchCase(null, new Statement[]{defaultCase}));
        }
        return new SwitchedMatch(result, switchStatement);
    }

    public static class Case {
        public final SwitchValue key;
        public final Expression value;

        public Case(SwitchValue key, Expression value) {
            this.key = key;
            this.value = value;
        }

        public Case transform(ExpressionTransformer transformer) {
            Expression tValue = this.value.transform(transformer);
            return tValue == this.value ? this : new Case(this.key, tValue);
        }

        public Case normalize(TypeScope scope) {
            return new Case(this.key, this.value.normalize(scope));
        }
    }

    public static class SwitchedMatch {
        public final VarStatement result;
        public final SwitchStatement switchStatement;

        public SwitchedMatch(VarStatement temp, SwitchStatement switchStatement) {
            this.result = temp;
            this.switchStatement = switchStatement;
        }
    }
}

