/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.context;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.annotations.AnnotationDefinition;
import org.openzen.zenscript.codemodel.context.CompilingPackage;
import org.openzen.zenscript.codemodel.context.TypeResolutionContext;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.ISymbol;
import org.openzen.zenscript.codemodel.type.TypeID;

public class ModuleTypeResolutionContext
implements TypeResolutionContext {
    private final GlobalTypeRegistry registry;
    private final Map<String, AnnotationDefinition> annotations = new HashMap<String, AnnotationDefinition>();
    private final Map<String, ISymbol> globals;
    private final ZSPackage rootPackage;
    private final CompilingPackage rootCompiling;

    public ModuleTypeResolutionContext(GlobalTypeRegistry registry, AnnotationDefinition[] annotations, ZSPackage rootPackage, CompilingPackage rootCompiling, Map<String, ISymbol> globals) {
        this.registry = registry;
        this.rootPackage = rootPackage;
        this.rootCompiling = rootCompiling;
        this.globals = globals;
        for (AnnotationDefinition annotation : annotations) {
            this.annotations.put(annotation.getAnnotationName(), annotation);
        }
    }

    @Override
    public ZSPackage getRootPackage() {
        return this.rootPackage;
    }

    @Override
    public GlobalTypeRegistry getTypeRegistry() {
        return this.registry;
    }

    @Override
    public AnnotationDefinition getAnnotation(String name) {
        return this.annotations.get(name);
    }

    @Override
    public TypeID getType(CodePosition position, List<GenericName> name) {
        TypeID compiling;
        if (this.rootCompiling != null && (compiling = this.rootCompiling.getType(this, name)) != null) {
            return compiling;
        }
        if (name.size() == 1 && this.globals.containsKey(name.get((int)0).name)) {
            return this.globals.get(name.get((int)0).name).getType(position, this, name.get((int)0).arguments);
        }
        return this.rootPackage.getType(position, (TypeResolutionContext)this, name);
    }

    @Override
    public TypeID getThisType() {
        return null;
    }
}

