/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.api.entity.INameTagFunction;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.tooltip.ITooltipFunction;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.platform.Services;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public interface IClientHelper {
    public static final Map<IIngredient, LinkedList<ITooltipFunction>> TOOLTIPS = new HashMap<IIngredient, LinkedList<ITooltipFunction>>();
    public static final Map<Predicate<Entity>, INameTagFunction> NAMETAGS = new HashMap<Predicate<Entity>, INameTagFunction>();

    default public boolean isSingleplayer() {
        return Minecraft.getInstance().hasSingleplayerServer();
    }

    public boolean isKeyDown(KeyMapping var1);

    public boolean isKeyDownExtra(KeyMapping var1);

    default public Map<IIngredient, LinkedList<ITooltipFunction>> getTooltips() {
        return TOOLTIPS;
    }

    default public void applyTooltips(ItemStack stack, Item.TooltipContext context, TooltipFlag flag, List<Component> lines) {
        IItemStack ctStack = IItemStack.of(stack);
        Services.CLIENT.getTooltips().forEach((ingredient, functions) -> {
            if (ingredient.matches(ctStack)) {
                functions.forEach(function -> {
                    try {
                        function.apply(ctStack, lines, context, flag);
                    }
                    catch (Exception exception) {
                        CommonLoggers.api().error("Unable to run one of the tooltip functions for {} on {} due to an error (for experts, refer to {})", (Object)ingredient.getCommandString(), (Object)ctStack.getCommandString(), (Object)function.getClass().getName(), (Object)exception);
                    }
                });
            }
        });
    }
}

