/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.predicate.builder;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.Map;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.GameTypePredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/predicate/builder/PlayerPredicateBuilder")
@NativeTypeRegistration(value=PlayerPredicate.Builder.class, zenCodeName="crafttweaker.api.predicate.builder.PlayerPredicateBuilder")
public final class ExpandPlayerPredicateBuilder {
    @ZenCodeType.Method
    public static PlayerPredicate.Builder level(PlayerPredicate.Builder internal, MinMaxBounds.Ints level) {
        return internal.setLevel(level);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder statistic(PlayerPredicate.Builder internal, ResourceLocation type, ResourceLocation name, MinMaxBounds.Ints value) {
        StatType statType = (StatType)BuiltInRegistries.STAT_TYPE.getOrThrow(ResourceKey.create((ResourceKey)Registries.STAT_TYPE, (ResourceLocation)type));
        Holder.Reference holder = statType.getRegistry().getHolderOrThrow((ResourceKey)GenericUtil.uncheck(ResourceKey.create((ResourceKey)statType.getRegistry().key(), (ResourceLocation)name)));
        return internal.addStat((StatType)GenericUtil.uncheck(statType), holder, value);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder statistic(PlayerPredicate.Builder internal, ResourceLocation type, String name, MinMaxBounds.Ints value) {
        return ExpandPlayerPredicateBuilder.statistic(internal, type, ResourceLocation.parse((String)name), value);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder statistic(PlayerPredicate.Builder internal, String type, ResourceLocation name, MinMaxBounds.Ints value) {
        return ExpandPlayerPredicateBuilder.statistic(internal, ResourceLocation.parse((String)type), name, value);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder statistic(PlayerPredicate.Builder internal, String type, String name, MinMaxBounds.Ints value) {
        return ExpandPlayerPredicateBuilder.statistic(internal, type, ResourceLocation.parse((String)name), value);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder recipe(PlayerPredicate.Builder internal, ResourceLocation name, @ZenCodeType.OptionalBoolean(value=true) boolean unlocked) {
        return internal.addRecipe(name, unlocked);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder recipe(PlayerPredicate.Builder internal, String name, @ZenCodeType.OptionalBoolean(value=true) boolean unlocked) {
        return ExpandPlayerPredicateBuilder.recipe(internal, ResourceLocation.parse((String)name), unlocked);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder gameType(PlayerPredicate.Builder internal, GameTypePredicate predicate) {
        return internal.setGameType(predicate);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder lookingAt(PlayerPredicate.Builder internal, EntityPredicate.Builder predicate) {
        return internal.setLookingAt(predicate);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder advancement(PlayerPredicate.Builder internal, ResourceLocation name, @ZenCodeType.OptionalBoolean(value=true) boolean completed) {
        return internal.checkAdvancementDone(name, completed);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder advancement(PlayerPredicate.Builder internal, String name, @ZenCodeType.OptionalBoolean(value=true) boolean completed) {
        return ExpandPlayerPredicateBuilder.advancement(internal, ResourceLocation.parse((String)name), completed);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder advancementCriteria(PlayerPredicate.Builder internal, ResourceLocation name, Map<String, Boolean> criteria) {
        return internal.checkAdvancementCriterions(name, criteria);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder advancementCriteria(PlayerPredicate.Builder internal, String name, Map<String, Boolean> criteria) {
        return ExpandPlayerPredicateBuilder.advancementCriteria(internal, ResourceLocation.parse((String)name), criteria);
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder advancementCriterion(PlayerPredicate.Builder internal, ResourceLocation name, String criterion, @ZenCodeType.OptionalBoolean(value=true) boolean completed) {
        return ExpandPlayerPredicateBuilder.advancementCriteria(internal, name, Map.of(criterion, completed));
    }

    @ZenCodeType.Method
    public static PlayerPredicate.Builder advancementCriterion(PlayerPredicate.Builder internal, String name, String criterion, @ZenCodeType.OptionalBoolean(value=true) boolean completed) {
        return ExpandPlayerPredicateBuilder.advancementCriterion(internal, ResourceLocation.parse((String)name), criterion, completed);
    }

    @ZenCodeType.Method
    public static PlayerPredicate build(PlayerPredicate.Builder internal) {
        return internal.build();
    }
}

