/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.loot.modifier;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.LootManager;
import com.blamejared.crafttweaker.api.loot.condition.LootConditions;
import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.natives.loot.condition.ExpandInvertedLootItemCondition;
import com.blamejared.crafttweaker.natives.loot.condition.ExpandLootItemBlockStatePropertyCondition;
import com.blamejared.crafttweaker.natives.loot.condition.ExpandMatchTool;
import com.blamejared.crafttweaker.natives.predicate.ExpandEnchantmentPredicate;
import com.blamejared.crafttweaker.natives.predicate.ExpandItemPredicate;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="vanilla/api/loot/modifier/BlockLootModifiers")
@ZenCodeType.Expansion(value="crafttweaker.api.block.Block")
@ZenRegister
public final class ModifierSpecificExpandBlock {
    @ZenCodeType.Method
    public static void addLootModifier(Block internal, String name, ILootModifier modifier) {
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.only((LootItemCondition.Builder)ExpandLootItemBlockStatePropertyCondition.create(internal)), modifier);
    }

    @ZenCodeType.Method
    public static void addNoSilkTouchLootModifier(Block internal, String name, ILootModifier modifier) {
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.allOf(new LootItemCondition.Builder[]{ExpandLootItemBlockStatePropertyCondition.create(internal), ExpandInvertedLootItemCondition.create(ExpandMatchTool.create(ExpandItemPredicate.create().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(ExpandEnchantmentPredicate.create((Enchantment)Services.REGISTRY.getOrThrow(Registries.ENCHANTMENT, Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1)))))))}), modifier);
    }

    @ZenCodeType.Method
    public static void addStateLootModifier(Block internal, String name, StatePropertiesPredicate.Builder statePredicate, ILootModifier modifier) {
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.only((LootItemCondition.Builder)ExpandLootItemBlockStatePropertyCondition.create(internal).setProperties(statePredicate)), modifier);
    }

    @ZenCodeType.Method
    public static void addToolLootModifier(Block internal, String name, IItemStack tool, ILootModifier modifier) {
        ModifierSpecificExpandBlock.addToolLootModifier(internal, name, tool, false, modifier);
    }

    @ZenCodeType.Method
    public static void addToolLootModifier(Block internal, String name, IItemStack tool, boolean matchComponents, ILootModifier modifier) {
        ItemPredicate.Builder predicateBuilder = ExpandItemPredicate.create(tool);
        if (matchComponents) {
            predicateBuilder.hasComponents(DataComponentPredicate.allOf((DataComponentMap)tool.getComponents()));
        }
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.allOf(new LootItemCondition.Builder[]{ExpandLootItemBlockStatePropertyCondition.create(internal), ExpandMatchTool.create(predicateBuilder)}), modifier);
    }
}

