/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.item.component;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/item/component/ItemContainerContents")
@NativeTypeRegistration(value=ItemContainerContents.class, zenCodeName="crafttweaker.api.item.component.ItemContainerContents")
public class ExpandItemContainerContents {
    @ZenCodeType.StaticExpansionMethod
    public static ItemContainerContents of(List<IItemStack> items) {
        return ItemContainerContents.fromItems((List)Lists.transform(items, IItemStack::getInternal));
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemContainerContents empty() {
        return ItemContainerContents.EMPTY;
    }

    @ZenCodeType.Method
    public static void copyInto(ItemContainerContents internal, List<IItemStack> stacks) {
        internal.copyInto(stacks.stream().map(IItemStack::getInternal).collect(Collectors.toCollection(() -> NonNullList.withSize((int)stacks.size(), (Object)ItemStack.EMPTY))));
    }

    @ZenCodeType.Getter(value="items")
    public static List<IItemStack> stream(ItemContainerContents internal) {
        return internal.stream().map(IItemStack::of).toList();
    }

    @ZenCodeType.Getter(value="nonEmptyItems")
    public static List<IItemStack> nonEmptyItemsCopy(ItemContainerContents internal) {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)internal.nonEmptyItemsCopy(), IItemStack::of));
    }

    @ZenCodeType.Getter(value="copyOne")
    public static IItemStack copyOne(ItemContainerContents internal) {
        return IItemStack.of(internal.copyOne());
    }
}

