/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.ingredient;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.Arrays;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="neoforge/api/ingredient/SizedIngredient")
@NativeTypeRegistration(value=SizedIngredient.class, zenCodeName="crafttweaker.neoforge.api.item.SizedIngredient")
public class ExpandSizedIngredient {
    @ZenCodeType.StaticExpansionMethod
    public static SizedIngredient of(KnownTag<Item> tag, int count) {
        return SizedIngredient.of(tag.getTagKey(), (int)count);
    }

    @ZenCodeType.StaticExpansionMethod
    public static SizedIngredient of(ItemLike item, int count) {
        return SizedIngredient.of((ItemLike)item, (int)count);
    }

    @ZenCodeType.StaticExpansionMethod
    public static SizedIngredient of(IIngredient ingredient, int count) {
        return new SizedIngredient(ingredient.asVanillaIngredient(), count);
    }

    @ZenCodeType.Getter(value="count")
    public static int count(SizedIngredient internal) {
        return internal.count();
    }

    @ZenCodeType.Method
    public static boolean test(SizedIngredient internal, IItemStack stack) {
        return internal.test(stack.getInternal());
    }

    @ZenCodeType.Getter(value="ingredient")
    public static IIngredient ingredient(SizedIngredient internal) {
        return IIngredient.fromIngredient(internal.ingredient());
    }

    @ZenCodeType.Getter(value="items")
    public static IItemStack[] getItems(SizedIngredient internal) {
        return (IItemStack[])Arrays.stream(internal.getItems()).map(IItemStack::of).toArray(IItemStack[]::new);
    }

    @ZenCodeType.Caster(implicit=true)
    public static IIngredientWithAmount asIIngredientWithAmount(SizedIngredient internal) {
        return new IngredientWithAmount(IIngredient.fromIngredient(internal.ingredient()), internal.count());
    }
}

