/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.helper;

import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessSmithingTransformRecipe;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessSmithingTrimRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import org.jetbrains.annotations.Nullable;

public final class SmithingRecipeConflictChecker {
    public static boolean doesConflict(IRecipeManager<?> manager, SmithingRecipe first, SmithingRecipe second) {
        BasicRecipe firstRecipe = BasicRecipe.from(first);
        BasicRecipe secondRecipe = BasicRecipe.from(second);
        if (firstRecipe == null || secondRecipe == null) {
            return SmithingRecipeConflictChecker.redirect((IRecipeManager)GenericUtil.uncheck(manager), second, first);
        }
        return IngredientUtil.canConflict(firstRecipe.template(), secondRecipe.template()) && IngredientUtil.canConflict(firstRecipe.base(), secondRecipe.base()) && IngredientUtil.canConflict(firstRecipe.addition(), secondRecipe.addition());
    }

    private static <T extends Recipe<?>> boolean redirect(IRecipeManager<?> manager, T second, Recipe<?> first) {
        return IRecipeHandlerRegistry.getHandlerFor(second).doesConflict((IRecipeManager)GenericUtil.uncheck(manager), second, first);
    }

    record BasicRecipe(Ingredient template, Ingredient base, Ingredient addition) {
        @Nullable
        static BasicRecipe from(SmithingRecipe recipe) {
            if (recipe instanceof SmithingTrimRecipe) {
                SmithingTrimRecipe trim = (SmithingTrimRecipe)recipe;
                return BasicRecipe.from(trim);
            }
            if (recipe instanceof SmithingTransformRecipe) {
                SmithingTransformRecipe transform = (SmithingTransformRecipe)recipe;
                return BasicRecipe.from(transform);
            }
            return null;
        }

        static BasicRecipe from(SmithingTrimRecipe recipe) {
            AccessSmithingTrimRecipe access = (AccessSmithingTrimRecipe)recipe;
            return new BasicRecipe(access.crafttweaker$getTemplate(), access.crafttweaker$getBase(), access.crafttweaker$getAddition());
        }

        static BasicRecipe from(SmithingTransformRecipe recipe) {
            AccessSmithingTransformRecipe access = (AccessSmithingTransformRecipe)recipe;
            return new BasicRecipe(access.crafttweaker$getTemplate(), access.crafttweaker$getBase(), access.crafttweaker$getAddition());
        }
    }
}

