/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.CraftTweakerCommon;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.loot.LootManager;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.PathUtil;
import com.blamejared.crafttweaker.api.villager.CTVillagerTrades;
import com.blamejared.crafttweaker.impl.command.CtCommands;
import com.blamejared.crafttweaker.mixin.common.access.level.damage.AccessDamageSources;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.blamejared.crafttweaker.natives.villager.ExpandVillagerProfession;
import com.blamejared.crafttweaker.natives.world.biome.ExpandBiome;
import com.blamejared.crafttweaker.platform.Services;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.apache.logging.log4j.Logger;

public final class DumpCommands {
    private DumpCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("dump_brackets", Component.translatable((String)"crafttweaker.command.description.dump.brackets"), builder -> builder.executes(context -> {
            DumpCommands.doFullBracketsDump((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
        handler.registerRootCommand("dump", Component.translatable((String)"crafttweaker.command.description.dump"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            CommandUtilities.send(source, (Component)Component.translatable((String)"crafttweaker.command.dump.types").append(": "));
            CtCommands.get().commands().get("dump").subCommands().keySet().stream().map(it -> CommandUtilities.run(Component.literal((String)"- ").append((Component)Component.literal((String)it).withStyle(ChatFormatting.GREEN)), "/ct dump " + it)).forEach(it -> CommandUtilities.send(source, it));
            return 1;
        }));
    }

    public static void registerDumpers(ICommandRegistrationHandler handler) {
        DumpCommands.registerBracketDumpers(handler);
        DumpCommands.registerCustomDumpers(handler);
    }

    private static void registerBracketDumpers(ICommandRegistrationHandler handler) {
        CraftTweakerAPI.getRegistry().getAllLoaders().stream().map(CraftTweakerAPI.getRegistry()::getBracketDumpers).map(Map::values).flatMap(Collection::stream).distinct().forEach(it -> {
            String subCommandName = it.subCommandName();
            handler.registerDump(subCommandName, it.description(), builder -> builder.executes((Command)it));
        });
    }

    private static void registerCustomDumpers(ICommandRegistrationHandler handler) {
        handler.registerDump("recipes", Component.translatable((String)"crafttweaker.command.description.dump.recipes"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.getLevel();
            AccessRecipeManager recipeManager = (AccessRecipeManager)level.getRecipeManager();
            recipeManager.crafttweaker$getByType().keySet().stream().peek(type -> CommandUtilities.COMMAND_LOGGER.info(type.toString())).map(it -> recipeManager.crafttweaker$getByType().get(it)).flatMap(Collection::stream).map(RecipeHolder::id).map(ResourceLocation::toString).forEach(arg_0 -> ((Logger)CommandUtilities.COMMAND_LOGGER).info(arg_0));
            CommandUtilities.openLogFile((CommandSourceStack)context.getSource(), (Component)Component.translatable((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.translatable((String)"crafttweaker.command.misc.recipes")), CommandUtilities.getFormattedLogFile()}).withStyle(ChatFormatting.GREEN));
            return 1;
        }));
        handler.registerDump("loot_modifiers", Component.translatable((String)"crafttweaker.command.description.dump.loot_modifiers"), builder -> builder.executes(context -> {
            LootManager.INSTANCE.getModifierManager().getAllNames().forEach(arg_0 -> ((Logger)CommandUtilities.COMMAND_LOGGER).info(arg_0));
            CommandUtilities.openLogFile((CommandSourceStack)context.getSource(), (Component)Component.translatable((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.translatable((String)"crafttweaker.command.misc.loot_modifiers")), CommandUtilities.getFormattedLogFile()}).withStyle(ChatFormatting.GREEN));
            return 1;
        }));
        handler.registerDump("loot_tables", Component.translatable((String)"crafttweaker.command.description.dump.loot_tables"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().lookupOrThrow(Registries.LOOT_TABLE).listElementIds().map(ResourceKey::location).map(ResourceLocation::toString).sorted().forEach(arg_0 -> ((Logger)CommandUtilities.COMMAND_LOGGER).info(arg_0));
            CommandUtilities.openLogFile(source, (Component)Component.translatable((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.translatable((String)"crafttweaker.command.misc.loot_tables")), CommandUtilities.getFormattedLogFile()}).withStyle(ChatFormatting.GREEN));
            return 1;
        }));
        handler.registerDump("biomes", Component.translatable((String)"crafttweaker.command.description.dump.biomes"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            MinecraftServer server = source.getServer();
            server.registryAccess().registry(Registries.BIOME).ifPresent(biomes -> biomes.stream().map(ExpandBiome::getCommandString).sorted().forEach(arg_0 -> ((Logger)CommandUtilities.COMMAND_LOGGER).info(arg_0)));
            CommandUtilities.openLogFile(source, (Component)Component.translatable((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.translatable((String)"crafttweaker.command.misc.biomes")), CommandUtilities.getFormattedLogFile()}).withStyle(ChatFormatting.GREEN));
            return 1;
        }));
        handler.registerDump("villager_trades", Component.translatable((String)"crafttweaker.command.description.dump.villager.trades"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            VillagerTrades.TRADES.forEach((villagerProfession, levelToTrades) -> {
                CommandUtilities.COMMAND_LOGGER.info("Trades for: " + ExpandVillagerProfession.getCommandString(villagerProfession));
                levelToTrades.keySet().intStream().sorted().filter(level -> ((VillagerTrades.ItemListing[])levelToTrades.getOrDefault(level, (Object)new VillagerTrades.ItemListing[0])).length > 0).peek(level -> CommandUtilities.COMMAND_LOGGER.info("Level " + level + " trades")).mapToObj(level -> (VillagerTrades.ItemListing[])levelToTrades.getOrDefault(level, (Object)new VillagerTrades.ItemListing[0])).flatMap(Arrays::stream).forEach(iTrade -> {
                    String tradeStr = " - Unable to display trade.";
                    if (CTVillagerTrades.TRADE_CONVERTER.containsKey(iTrade.getClass())) {
                        tradeStr = CTVillagerTrades.TRADE_CONVERTER.get(iTrade.getClass()).apply((VillagerTrades.ItemListing)iTrade).toString();
                    }
                    CommandUtilities.COMMAND_LOGGER.info(iTrade.getClass().getSimpleName() + tradeStr);
                });
            });
            CommandUtilities.openLogFile(source, (Component)Component.translatable((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.translatable((String)"crafttweaker.command.misc.villager.trades")), CommandUtilities.getFormattedLogFile()}).withStyle(ChatFormatting.GREEN));
            return 1;
        }));
        handler.registerDump("wandering_trades", Component.translatable((String)"crafttweaker.command.description.dump.wandering.trades"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            CommandUtilities.COMMAND_LOGGER.info("Wandering Trader Trades");
            VillagerTrades.WANDERING_TRADER_TRADES.keySet().intStream().sorted().filter(level -> ((VillagerTrades.ItemListing[])VillagerTrades.WANDERING_TRADER_TRADES.getOrDefault(level, (Object)new VillagerTrades.ItemListing[0])).length > 0).peek(level -> CommandUtilities.COMMAND_LOGGER.info("Level " + level + " trades")).mapToObj(level -> (VillagerTrades.ItemListing[])VillagerTrades.WANDERING_TRADER_TRADES.getOrDefault(level, (Object)new VillagerTrades.ItemListing[0])).flatMap(Arrays::stream).forEach(iTrade -> {
                String tradeStr = " - Unable to display trade.";
                if (CTVillagerTrades.TRADE_CONVERTER.containsKey(iTrade.getClass())) {
                    tradeStr = CTVillagerTrades.TRADE_CONVERTER.get(iTrade.getClass()).apply((VillagerTrades.ItemListing)iTrade).toString();
                }
                CommandUtilities.COMMAND_LOGGER.info(iTrade.getClass().getSimpleName() + tradeStr);
            });
            CommandUtilities.openLogFile(source, (Component)Component.translatable((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.translatable((String)"crafttweaker.command.misc.wandering.trades")), CommandUtilities.getFormattedLogFile()}).withStyle(ChatFormatting.GREEN));
            return 1;
        }));
        handler.registerDump("tag_contents", Component.translatable((String)"crafttweaker.command.description.dump.tag.contents"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            CommandUtilities.COMMAND_LOGGER.info("All Tag Contents");
            RegistryAccess registryAccess = ((CommandSourceStack)context.getSource()).registryAccess();
            registryAccess.registries().sorted(Comparator.comparing(o -> o.key().location())).forEach(entry -> {
                Registry registry = entry.value();
                String tagFolder = CraftTweakerTagRegistry.INSTANCE.makeTagFolder(registry.key());
                CommandUtilities.COMMAND_LOGGER.info("Contents of '{}' tags:", (Object)tagFolder);
                registry.getTags().sorted(Comparator.comparing(o -> ((TagKey)o.getFirst()).location())).forEach(pair -> {
                    CommandUtilities.COMMAND_LOGGER.info("<tag:" + tagFolder + ":" + String.valueOf(((TagKey)pair.getFirst()).location()) + ">");
                    Function<Holder, ResourceLocation> keyExtractor = holder -> (ResourceLocation)holder.unwrap().map(ResourceKey::location, o -> registry.getKey(GenericUtil.uncheck(o)));
                    ((HolderSet.Named)pair.getSecond()).stream().map(keyExtractor).sorted(ResourceLocation::compareTo).forEach(resourceLocation -> CommandUtilities.COMMAND_LOGGER.info("\t- {}", resourceLocation));
                });
            });
            CommandUtilities.openLogFile(source, (Component)Component.translatable((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.translatable((String)"crafttweaker.command.misc.tag.contents")), CommandUtilities.getFormattedLogFile()}).withStyle(ChatFormatting.GREEN));
            return 1;
        }));
        handler.registerDump("damage_sources", Component.translatable((String)"crafttweaker.command.description.dump.damage_sources"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ((AccessDamageSources)source.getLevel().damageSources()).crafttweaker$getDamageTypes().keySet().stream().sorted().forEach(arg_0 -> ((Logger)CommandUtilities.COMMAND_LOGGER).info(arg_0));
            CommandUtilities.openLogFile(source, (Component)Component.translatable((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.translatable((String)"crafttweaker.command.misc.biomes")), CommandUtilities.getFormattedLogFile()}).withStyle(ChatFormatting.GREEN));
            return 1;
        }));
        handler.registerDump("fake_players", Component.translatable((String)"crafttweaker.command.description.dump.fake_players"), builder -> builder.executes(context -> {
            Services.PLATFORM.fakePlayers().map(it -> it.getName() + " -> " + String.valueOf(it.getId())).forEach(it -> CraftTweakerCommon.logger().info(it));
            CommandUtilities.openLogFile((CommandSourceStack)context.getSource(), (Component)Component.translatable((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.translatable((String)"crafttweaker.command.misc.fake_players")), CommandUtilities.getFormattedLogFile()}).withStyle(ChatFormatting.GREEN));
            return 1;
        }));
    }

    private static String getTagAsString(CommandSourceStack source, MCTag tag, Object o) {
        if (o instanceof ResourceLocation) {
            return o.toString();
        }
        Optional foundRegistry = source.registryAccess().registry(tag.manager().resourceKey());
        if (foundRegistry.isPresent()) {
            return foundRegistry.map(objects -> objects.getKey(o)).map(ResourceLocation::toString).orElse(o.toString());
        }
        return o.toString();
    }

    private static void doFullBracketsDump(CommandContext<CommandSourceStack> context) {
        Path directory = PathUtil.findFromGameDirectory("ct_dumps");
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            CommandUtilities.COMMAND_LOGGER.error("Could not create output folder '{}'", (Object)directory);
            return;
        }
        CraftTweakerAPI.getRegistry().getAllLoaders().stream().map(CraftTweakerAPI.getRegistry()::getBracketDumpers).map(Map::values).flatMap(Collection::stream).distinct().forEach(it -> {
            String dumpedFileName = it.dumpedFileName() + ".txt";
            Iterable iterable = () -> it.values().sorted().iterator();
            try {
                Files.write(directory.resolve(dumpedFileName), iterable, new OpenOption[0]);
            }
            catch (IOException e) {
                CommandUtilities.COMMAND_LOGGER.error("Error writing to file '" + dumpedFileName + "'", (Throwable)e);
            }
        });
        CommandUtilities.open((CommandSourceStack)context.getSource(), "ct_dumps");
    }
}

