/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.ingredient.condition.IngredientConditions;
import com.blamejared.crafttweaker.natives.component.ExpandDataComponentType;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class ItemStackUtil {
    public static String getCommandString(ItemLike itemLike) {
        return ItemStackUtil.getCommandString(itemLike.asItem().getDefaultInstance());
    }

    public static String getCommandString(ItemStack stack) {
        return ItemStackUtil.getCommandString(stack, false);
    }

    public static String getCommandString(ItemStack stack, boolean mutable) {
        StringBuilder sb = new StringBuilder("<item:").append(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).append('>');
        DataComponentPatch.SplitResult split = stack.getComponentsPatch().split();
        split.added().filter(Predicate.not(DataComponentType::isTransient)).forEach(typedDataComponent -> sb.append(".withJsonComponent(").append(ExpandDataComponentType.getCommandString(typedDataComponent.type())).append(", ").append(typedDataComponent.encodeValue(IDataOps.INSTANCE.withRegistryAccess()).getOrThrow()).append(")"));
        split.removed().forEach(dataComponentType -> sb.append(".without(").append(ExpandDataComponentType.getCommandString(dataComponentType)).append(")"));
        if (!stack.isEmpty() && stack.getCount() != 1) {
            sb.append(" * ").append(stack.getCount());
        }
        if (mutable) {
            sb.insert(0, '(').append(").mutable()");
        }
        return sb.toString();
    }

    public static boolean areStacksTheSame(ItemStack first, ItemStack second) {
        return ItemStackUtil.areStacksTheSame(first, second, IngredientConditions.EMPTY);
    }

    public static boolean areStacksTheSame(ItemStack first, ItemStack second, IngredientConditions conditions) {
        if (first == null || second == null) {
            return first == second;
        }
        if (first.isEmpty() != second.isEmpty()) {
            return false;
        }
        if (first.getItem() != second.getItem()) {
            return false;
        }
        if (first.getCount() > second.getCount()) {
            return false;
        }
        return DataComponentPredicate.allOf((DataComponentMap)first.getComponents().filter(conditions.componentFilter())).test((DataComponentHolder)second);
    }
}

