/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.serializer;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction2D;
import com.blamejared.crafttweaker.api.recipe.type.CTShapedRecipe;
import com.blamejared.crafttweaker.api.util.RecipeUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class CTShapedRecipeSerializer
implements RecipeSerializer<CTShapedRecipe> {
    public static final CTShapedRecipeSerializer INSTANCE = new CTShapedRecipeSerializer();
    public static final MapCodec<CTShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IItemStack.CODEC.fieldOf("output").forGetter(CTShapedRecipe::getCtOutput), (App)IIngredient.CODEC.listOf().listOf().fieldOf("ingredients").xmap(lists -> (IIngredient[][])lists.stream().map(ingredients -> (IIngredient[])ingredients.toArray(IIngredient[]::new)).toArray(x$0 -> new IIngredient[x$0][]), ingredients -> Arrays.stream(ingredients).map(iIngredients -> Arrays.stream(iIngredients).toList()).toList()).forGetter(CTShapedRecipe::getCtIngredients), (App)MirrorAxis.CODEC.fieldOf("mirror_axis").forGetter(CTShapedRecipe::getMirrorAxis)).apply((Applicative)instance, CTShapedRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CTShapedRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ShapedRecipe::getHeight, (StreamCodec)ByteBufCodecs.VAR_INT, ShapedRecipe::getWidth, (StreamCodec)IIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), CTShapedRecipe::getFlatCtIngredients, IItemStack.STREAM_CODEC, CTShapedRecipe::getCtOutput, (StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, MirrorAxis>(){

        public MirrorAxis decode(RegistryFriendlyByteBuf buffer) {
            return (MirrorAxis)buffer.readEnum(MirrorAxis.class);
        }

        public void encode(RegistryFriendlyByteBuf buffer, MirrorAxis axis) {
            buffer.writeEnum((Enum)axis);
        }
    }, CTShapedRecipe::getMirrorAxis, (height, width, ingredients, output, mirrorAxis) -> new CTShapedRecipe((IItemStack)output, RecipeUtil.inflate(ingredients, width, height), (MirrorAxis)((Object)mirrorAxis)));

    private CTShapedRecipeSerializer() {
    }

    public MapCodec<CTShapedRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, CTShapedRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    private static CTShapedRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        int height = buffer.readVarInt();
        int width = buffer.readVarInt();
        IIngredient[][] inputs = new IIngredient[height][width];
        for (int h = 0; h < inputs.length; ++h) {
            for (int w = 0; w < inputs[h].length; ++w) {
                inputs[h][w] = IIngredient.fromIngredient((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            }
        }
        MirrorAxis mirrorAxis = (MirrorAxis)buffer.readEnum(MirrorAxis.class);
        ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        return CTShapedRecipeSerializer.makeRecipe(IItemStack.of(output), inputs, mirrorAxis, null);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, CTShapedRecipe recipe) {
        buffer.writeVarInt(recipe.getHeight());
        buffer.writeVarInt(recipe.getWidth());
        for (Ingredient ingredient : recipe.getIngredients()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
        }
        buffer.writeEnum((Enum)recipe.getMirrorAxis());
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)AccessibleElementsProvider.get().registryAccess(recipe::getResultItem));
    }

    private static CTShapedRecipe makeRecipe(IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable RecipeFunction2D function) {
        return new CTShapedRecipe(output, ingredients, mirrorAxis, function);
    }
}

