/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement.type;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.recipe.replacement.IFilteringRule;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="vanilla/api/recipe/replacement/type/NameFilteringRule")
@ZenCodeType.Name(value="crafttweaker.api.recipe.replacement.type.NameFilteringRule")
@ZenRegister
public final class NameFilteringRule
implements IFilteringRule {
    private final Matcher matcher;

    private NameFilteringRule(Matcher matcher) {
        this.matcher = matcher;
    }

    @ZenCodeType.Method
    public static NameFilteringRule anyOf(String ... exactNames) {
        if (exactNames.length < 1) {
            throw new IllegalArgumentException("Unable to build name filtering rule without at least one name");
        }
        return NameFilteringRule.of(new ExactMatcher(Set.of(exactNames)));
    }

    @ZenCodeType.Method
    public static NameFilteringRule containing(String contents) {
        if (contents.isEmpty()) {
            throw new IllegalArgumentException("Everything contains the empty string");
        }
        return NameFilteringRule.of(new SimpleMatcher(contents));
    }

    @ZenCodeType.Method
    public static NameFilteringRule regex(String regex) {
        return NameFilteringRule.of(new RegexMatcher(Pattern.compile(regex)));
    }

    private static NameFilteringRule of(Matcher matcher) {
        return new NameFilteringRule(matcher);
    }

    @Override
    public Stream<RecipeHolder<?>> castFilter(Stream<RecipeHolder<?>> allRecipes) {
        return allRecipes.filter(it -> this.matcher.matches(it.id().toString()));
    }

    @Override
    public String describe() {
        return "recipes matching " + this.matcher.toString();
    }

    @FunctionalInterface
    private static interface Matcher {
        public boolean matches(String var1);
    }

    private record ExactMatcher(Set<String> exact) implements Matcher
    {
        @Override
        public boolean matches(String s) {
            return this.exact().contains(s);
        }

        @Override
        public String toString() {
            return "exactly one of " + this.exact().toString().replace('[', '{').replace(']', '}');
        }
    }

    private record SimpleMatcher(String content) implements Matcher
    {
        @Override
        public boolean matches(String s) {
            return this.content().contains(s);
        }

        @Override
        public String toString() {
            return "anything containing " + this.content();
        }
    }

    private record RegexMatcher(Pattern pattern) implements Matcher
    {
        @Override
        public boolean matches(String s) {
            return this.pattern().matcher(s).matches();
        }

        @Override
        public String toString() {
            return this.pattern().toString();
        }
    }
}

