/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.vanilla.DelegatingCustomIngredient;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.CraftTweakerVanillaIngredientSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientAnySerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientCraftTweakerSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientIItemStackSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientListSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.CraftTweakerVanillaIngredient;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientAny;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientCraftTweaker;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientIItemStack;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientList;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class CraftTweakerIngredients {
    private static final BiMap<CraftTweakerVanillaIngredientSerializer<?>, IngredientType<? extends ICustomIngredient>> SERIALIZER_CACHE = HashBiMap.create();
    private static final BiMap<CraftTweakerVanillaIngredient, DelegatingCustomIngredient<?>> SINGLETON_CACHE = HashBiMap.create();

    public static class Types {
        public static final IngredientType<?> ANY = Types.of(IngredientAnySerializer.INSTANCE);
        public static final IngredientType<?> LIST = Types.of(IngredientListSerializer.INSTANCE);
        public static final IngredientType<?> CRAFTTWEAKER = Types.of(IngredientCraftTweakerSerializer.INSTANCE);
        public static final IngredientType<?> IITEMSTACK = Types.of(IngredientIItemStackSerializer.INSTANCE);

        static <T extends CraftTweakerVanillaIngredient> IngredientType<DelegatingCustomIngredient<T>> of(CraftTweakerVanillaIngredientSerializer<T> ingredient) {
            return (IngredientType)GenericUtil.uncheck(SERIALIZER_CACHE.computeIfAbsent(ingredient, DelegatingCustomIngredient::ingredientType));
        }
    }

    public static class Ingredients {
        public static ICustomIngredient any() {
            return (ICustomIngredient)SINGLETON_CACHE.computeIfAbsent((Object)IngredientAny.of(), DelegatingCustomIngredient::new);
        }

        public static <T extends IIngredient> ICustomIngredient crafttweaker(T internal) {
            return new DelegatingCustomIngredient<IngredientCraftTweaker<T>>(IngredientCraftTweaker.of(internal));
        }

        public static ICustomIngredient iitemstack(IItemStack internal) {
            return new DelegatingCustomIngredient<IngredientIItemStack>(IngredientIItemStack.of(internal));
        }

        public static ICustomIngredient list(List<Ingredient> children) {
            return new DelegatingCustomIngredient<IngredientList>(IngredientList.of(children));
        }

        static <T extends CraftTweakerVanillaIngredient> DelegatingCustomIngredient<T> of(T ingredient) {
            if (ingredient.singleton()) {
                return (DelegatingCustomIngredient)GenericUtil.uncheck(SINGLETON_CACHE.computeIfAbsent(ingredient, DelegatingCustomIngredient::new));
            }
            return new DelegatingCustomIngredient<T>(ingredient);
        }
    }
}

