/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data.op;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.data.BoolData;
import com.blamejared.crafttweaker.api.data.ByteArrayData;
import com.blamejared.crafttweaker.api.data.ByteData;
import com.blamejared.crafttweaker.api.data.DoubleData;
import com.blamejared.crafttweaker.api.data.EmptyData;
import com.blamejared.crafttweaker.api.data.FloatData;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.IntArrayData;
import com.blamejared.crafttweaker.api.data.IntData;
import com.blamejared.crafttweaker.api.data.ListData;
import com.blamejared.crafttweaker.api.data.LongArrayData;
import com.blamejared.crafttweaker.api.data.LongData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.ShortData;
import com.blamejared.crafttweaker.api.data.StringData;
import com.blamejared.crafttweaker.api.data.op.DecidingListDataAdapter;
import com.blamejared.crafttweaker.api.data.op.IDataListBuilder;
import com.blamejared.crafttweaker.api.data.op.IDataMapBuilder;
import com.blamejared.crafttweaker.api.data.op.ListDataAdapter;
import com.blamejared.crafttweaker.api.data.op.MapLikeMapData;
import com.blamejared.crafttweaker.api.data.op.OpUtils;
import com.blamejared.crafttweaker.api.data.op.SameTypeListDataAdapter;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.Optionull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;

public final class IDataOps
implements DynamicOps<IData> {
    public static final IDataOps INSTANCE = new IDataOps();

    private IDataOps() {
    }

    public RegistryOps<IData> withRegistryAccess() {
        return this.withRegistryAccess(CraftTweakerAPI.getAccessibleElementsProvider().registryAccess());
    }

    public RegistryOps<IData> withTagAddingRegistryAccess() {
        return CraftTweakerAPI.getAccessibleElementsProvider().tagAddingRegistryLookup().createSerializationContext(this);
    }

    public RegistryOps<IData> withRegistryAccess(RegistryAccess access) {
        return access.createSerializationContext((DynamicOps)this);
    }

    public IData empty() {
        return EmptyData.INSTANCE;
    }

    public <U> U convertTo(DynamicOps<U> outOps, IData input) {
        if (this == outOps) {
            return (U)GenericUtil.uncheck(input.copy());
        }
        return (U)(switch (input.getType()) {
            default -> throw new MatchException(null, null);
            case IData.Type.BOOL -> outOps.createBoolean(input.asBool());
            case IData.Type.BYTE_ARRAY -> outOps.createByteList(ByteBuffer.wrap(input.asByteArray()));
            case IData.Type.BYTE -> outOps.createByte(input.asByte());
            case IData.Type.DOUBLE -> outOps.createDouble(input.asDouble());
            case IData.Type.FLOAT -> outOps.createFloat(input.asFloat());
            case IData.Type.INT_ARRAY -> outOps.createIntList(IntStream.of(input.asIntArray()));
            case IData.Type.INT -> outOps.createInt(input.asInt());
            case IData.Type.LIST -> this.convertList(outOps, input);
            case IData.Type.LONG_ARRAY -> outOps.createLongList(LongStream.of(input.asLongArray()));
            case IData.Type.LONG -> outOps.createLong(input.asLong());
            case IData.Type.MAP -> this.convertMap(outOps, input);
            case IData.Type.SHORT -> outOps.createShort(input.asShort());
            case IData.Type.STRING -> outOps.createString(input.getAsString());
            case IData.Type.EMPTY -> outOps.empty();
        });
    }

    public DataResult<Number> getNumberValue(IData input) {
        return switch (input.getType()) {
            case IData.Type.BYTE -> DataResult.success((Object)input.asByte());
            case IData.Type.DOUBLE -> DataResult.success((Object)input.asDouble());
            case IData.Type.FLOAT -> DataResult.success((Object)Float.valueOf(input.asFloat()));
            case IData.Type.INT -> DataResult.success((Object)input.asInt());
            case IData.Type.LONG -> DataResult.success((Object)input.asLong());
            case IData.Type.SHORT -> DataResult.success((Object)input.asShort());
            default -> this.noType(input, "number");
        };
    }

    public IData createNumeric(Number i) {
        return new DoubleData(i.doubleValue());
    }

    public DataResult<String> getStringValue(IData input) {
        return input.getType() == IData.Type.STRING ? DataResult.success((Object)input.getAsString()) : this.noType(input, "string");
    }

    public IData createString(String value) {
        return new StringData(value);
    }

    public DataResult<IData> mergeToList(IData list, IData value) {
        return (DataResult)Optionull.mapOrElse(this.adaptToStreamedList(list), it -> DataResult.success((Object)((IData)it.apply(Stream.of(value)))), () -> this.noType(list, "list"));
    }

    public DataResult<IData> mergeToMap(IData map, IData key, IData value) {
        if (map.getType() != IData.Type.MAP && map != this.empty()) {
            return this.noType(map, "map");
        }
        if (key.getType() != IData.Type.STRING && map != this.empty()) {
            return this.noType(key, "string");
        }
        MapData other = map == this.empty() ? new MapData() : (MapData)GenericUtil.uncheck(map.copyInternal());
        other.put(key.getAsString(), value);
        return DataResult.success((Object)other);
    }

    public DataResult<Stream<Pair<IData, IData>>> getMapValues(IData input) {
        return input.getType() == IData.Type.MAP ? DataResult.success(input.getKeys().stream().map(it -> Pair.of((Object)new StringData((String)it), (Object)input.getAt((String)it)))) : this.noType(input, "map");
    }

    public IData createMap(Stream<Pair<IData, IData>> map) {
        MapData data = new MapData();
        map.forEach(pair -> data.put(((IData)pair.getFirst()).getAsString(), ((IData)pair.getSecond()).copyInternal()));
        return data;
    }

    public DataResult<Stream<IData>> getStream(IData input) {
        return switch (input.getType()) {
            case IData.Type.LIST -> {
                ListData data = (ListData)GenericUtil.uncheck(input);
                boolean mightBeWrapper = data.getInternal().getElementType() == 10;
                Stream result = data.asList().stream().map(mightBeWrapper ? this::unwrapIfNeeded : Function.identity());
                yield DataResult.success(result);
            }
            case IData.Type.BYTE_ARRAY, IData.Type.INT_ARRAY, IData.Type.LONG_ARRAY -> DataResult.success(input.asList().stream());
            default -> this.noType(input, "list");
        };
    }

    public IData createList(Stream<IData> input) {
        return Objects.requireNonNull(this.adaptToStreamedList(this.empty())).apply(input);
    }

    public IData remove(IData input, String key) {
        if (input.getType() != IData.Type.MAP) {
            return input;
        }
        MapData data = (MapData)GenericUtil.uncheck(input.copyInternal());
        data.remove(key);
        return data;
    }

    public IData emptyMap() {
        return new MapData();
    }

    public IData emptyList() {
        return new ListData();
    }

    public Number getNumberValue(IData input, Number defaultValue) {
        return this.getNumberValue(input).result().orElse(defaultValue);
    }

    public IData createByte(byte value) {
        return new ByteData(value);
    }

    public IData createShort(short value) {
        return new ShortData(value);
    }

    public IData createInt(int value) {
        return new IntData(value);
    }

    public IData createLong(long value) {
        return new LongData(value);
    }

    public IData createFloat(float value) {
        return new FloatData(value);
    }

    public IData createDouble(double value) {
        return new DoubleData(value);
    }

    public DataResult<Boolean> getBooleanValue(IData input) {
        return switch (input.getType()) {
            case IData.Type.BOOL -> DataResult.success((Object)input.asBool());
            case IData.Type.BYTE -> DataResult.success((Object)(input.asByte() != 0 ? 1 : 0));
            default -> this.noType(input, "boolean");
        };
    }

    public IData createBoolean(boolean value) {
        return new BoolData(value);
    }

    public DataResult<IData> mergeToList(IData list, List<IData> values) {
        return values.stream().reduce(DataResult.success((Object)(list == this.empty() ? new ListData() : list)), (result, value) -> result.flatMap(l -> this.mergeToList((IData)l, (IData)value)), OpUtils.noCombiner());
    }

    public DataResult<IData> mergeToMap(IData map, Map<IData, IData> values) {
        return values.entrySet().stream().reduce(DataResult.success((Object)(map == this.empty() ? new MapData() : map)), (result, entry) -> result.flatMap(m -> this.mergeToMap((IData)m, (IData)entry.getKey(), (IData)entry.getValue())), OpUtils.noCombiner());
    }

    public DataResult<IData> mergeToMap(IData map, MapLike<IData> values) {
        return values.entries().reduce(DataResult.success((Object)(map == this.empty() ? new MapData() : map)), (result, pair) -> result.flatMap(m -> this.mergeToMap((IData)m, (IData)pair.getFirst(), (IData)pair.getSecond())), OpUtils.noCombiner());
    }

    public DataResult<IData> mergeToPrimitive(IData prefix, IData value) {
        if (prefix.getType() != IData.Type.EMPTY) {
            return DataResult.error(() -> "Unable to append " + String.valueOf(value) + " to " + String.valueOf(prefix) + " primitively", (Object)value);
        }
        return DataResult.success((Object)value);
    }

    public DataResult<Consumer<BiConsumer<IData, IData>>> getMapEntries(IData input) {
        if (input.getType() != IData.Type.MAP) {
            return this.noType(input, "map");
        }
        MapData map = (MapData)GenericUtil.uncheck(input);
        Stream<Pair> entries = map.getKeys().stream().map(it -> Pair.of((Object)new StringData((String)it), (Object)map.getAt((String)it)));
        return DataResult.success(acceptor -> entries.forEach(pair -> acceptor.accept((IData)pair.getFirst(), (IData)pair.getSecond())));
    }

    public DataResult<MapLike<IData>> getMap(IData input) {
        if (input.getType() != IData.Type.MAP) {
            return this.noType(input, "map");
        }
        MapData data = (MapData)GenericUtil.uncheck(input);
        MapLikeMapData mapLike = MapLikeMapData.of(data);
        return DataResult.success((Object)mapLike);
    }

    public IData createMap(Map<IData, IData> map) {
        return this.createMap(map.entrySet().stream().map(it -> Pair.of((Object)((IData)it.getKey()), (Object)((IData)it.getValue()))));
    }

    public DataResult<Consumer<Consumer<IData>>> getList(IData input) {
        return switch (input.getType()) {
            case IData.Type.LIST -> {
                ListData data = (ListData)GenericUtil.uncheck(input);
                boolean mightBeWrapper = data.getInternal().getElementType() == 10;
                Stream dataStream = data.asList().stream().map(mightBeWrapper ? this::unwrapIfNeeded : Function.identity());
                yield DataResult.success(acceptor -> dataStream.forEach(acceptor));
            }
            case IData.Type.BYTE_ARRAY, IData.Type.INT_ARRAY, IData.Type.LONG_ARRAY -> DataResult.success(acceptor -> input.asList().forEach(acceptor));
            default -> this.noType(input, "list");
        };
    }

    public DataResult<ByteBuffer> getByteBuffer(IData input) {
        return input.getType() == IData.Type.BYTE_ARRAY ? DataResult.success((Object)ByteBuffer.wrap(input.asByteArray())) : super.getByteBuffer((Object)input);
    }

    public IData createByteList(ByteBuffer input) {
        byte[] array = new byte[input.limit()];
        input.get(array, 0, array.length);
        return new ByteArrayData(array);
    }

    public DataResult<IntStream> getIntStream(IData input) {
        return input.getType() == IData.Type.INT_ARRAY ? DataResult.success((Object)IntStream.of(input.asIntArray())) : super.getIntStream((Object)input);
    }

    public IData createIntList(IntStream input) {
        return new IntArrayData(input.toArray());
    }

    public DataResult<LongStream> getLongStream(IData input) {
        return input.getType() == IData.Type.LONG_ARRAY ? DataResult.success((Object)LongStream.of(input.asLongArray())) : super.getLongStream((Object)input);
    }

    public IData createLongList(LongStream input) {
        return new LongArrayData(input.toArray());
    }

    public DataResult<IData> get(IData input, String key) {
        return input.getType() == IData.Type.MAP ? (DataResult)Optionull.mapOrElse((Object)input.getAt(key), DataResult::success, () -> DataResult.error(() -> "No such key %s in %s".formatted(key, input))) : this.noType(input, "map");
    }

    public DataResult<IData> getGeneric(IData input, IData key) {
        return key.getType() == IData.Type.STRING ? this.get(input, key.getAsString()) : DataResult.error(() -> "No such key %s in %s".formatted(key, input));
    }

    public IData set(IData input, String key, IData value) {
        return this.mergeToMap(input, new StringData(key), value).result().orElse(input);
    }

    public IData update(IData input, String key, Function<IData, IData> function) {
        return this.updateGeneric(input, new StringData(key), function);
    }

    public IData updateGeneric(IData input, IData key, Function<IData, IData> function) {
        return this.mergeToMap(input, key, function.apply(this.getGeneric(input, key).result().orElseGet(this::empty))).result().orElse(input);
    }

    public ListBuilder<IData> listBuilder() {
        return IDataListBuilder.of(this);
    }

    public RecordBuilder<IData> mapBuilder() {
        return IDataMapBuilder.of(this);
    }

    public <E> Function<E, DataResult<IData>> withEncoder(Encoder<E> encoder) {
        return element -> encoder.encode(element, (DynamicOps)this, (Object)this.empty());
    }

    public <E> Function<IData, DataResult<Pair<E, IData>>> withDecoder(Decoder<E> decoder) {
        return data -> decoder.decode((DynamicOps)this, data);
    }

    public <E> Function<IData, DataResult<E>> withParser(Decoder<E> decoder) {
        return data -> decoder.parse((DynamicOps)this, data);
    }

    public <U> U convertList(DynamicOps<U> outOps, IData input) {
        Stream listStream = this.getStream(input).map(stream -> stream.map(it -> this.convertTo(outOps, (IData)it))).result().orElseGet(Stream::empty);
        return (U)outOps.createList(listStream);
    }

    public <U> U convertMap(DynamicOps<U> outOps, IData input) {
        Stream mapStream = this.getMapValues(input).map(stream -> stream.map(it -> it.mapFirst(f -> this.convertTo(outOps, (IData)f)))).map(stream -> stream.map(it -> it.mapSecond(s -> this.convertTo(outOps, (IData)s)))).result().orElseGet(Stream::empty);
        return (U)outOps.createMap(mapStream);
    }

    public String toString() {
        return "IData";
    }

    private <R> DataResult<R> noType(IData data, String expect) {
        return DataResult.error(() -> String.valueOf((Object)data.getType()) + " is not a valid type for " + expect);
    }

    private Function<Stream<IData>, IData> adaptToStreamedList(IData data) {
        ListDataAdapter adapter = this.adaptToList(data);
        return adapter == null ? null : it -> it.reduce(adapter, Function::apply, OpUtils.noCombiner()).finish();
    }

    private ListDataAdapter adaptToList(IData data) {
        return switch (data.getType()) {
            case IData.Type.BYTE_ARRAY, IData.Type.INT_ARRAY, IData.Type.LIST, IData.Type.LONG_ARRAY -> this.orEmpty(data, SameTypeListDataAdapter::list);
            case IData.Type.EMPTY -> DecidingListDataAdapter.of();
            default -> null;
        };
    }

    private ListDataAdapter orEmpty(IData data, Function<IData, ListDataAdapter> alternative) {
        return data.asList().isEmpty() ? DecidingListDataAdapter.of() : alternative.apply(data);
    }

    private IData unwrapIfNeeded(IData other) {
        if (other.getType() != IData.Type.MAP) {
            return other;
        }
        MapData data = (MapData)GenericUtil.uncheck(other);
        Set<String> keys = data.getKeys();
        if (keys.size() == 1 && keys.contains("$$wrapped$$")) {
            return data.getAt("$$wrapped$$");
        }
        return data;
    }
}

