/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.bracket.custom;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.util.ParseUtil;
import com.blamejared.crafttweaker.api.zencode.IScriptLoader;
import com.blamejared.crafttweaker.api.zencode.IZenClassRegistry;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedCallArguments;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.expression.ParsedExpressionCall;
import org.openzen.zenscript.parser.expression.ParsedExpressionMember;
import org.openzen.zenscript.parser.type.IParsedType;

@ZenCodeType.Name(value="crafttweaker.api.bracket.RecipeComponentBracketHandler")
@ZenRegister
public final class RecipeComponentBracketHandler
implements BracketExpressionParser {
    private static final String BRACKET_METHOD_NAME = "bracket";
    private static final Map<Class<?>, String> STDLIB_TYPES = (Map)Util.make(() -> {
        Object2ObjectArrayMap m = new Object2ObjectArrayMap();
        m.put(List.class, "stdlib.List");
        m.put(String.class, "string");
        RecipeComponentBracketHandler.put(m, Void.class, Void.TYPE, BasicTypeID.VOID);
        RecipeComponentBracketHandler.put(m, Boolean.class, Boolean.TYPE, BasicTypeID.BOOL);
        RecipeComponentBracketHandler.put(m, Byte.class, Byte.TYPE, BasicTypeID.SBYTE);
        RecipeComponentBracketHandler.put(m, Short.class, Short.TYPE, BasicTypeID.SHORT);
        RecipeComponentBracketHandler.put(m, Integer.class, Integer.TYPE, BasicTypeID.INT);
        RecipeComponentBracketHandler.put(m, Long.class, Long.TYPE, BasicTypeID.LONG);
        RecipeComponentBracketHandler.put(m, Float.class, Float.TYPE, BasicTypeID.FLOAT);
        RecipeComponentBracketHandler.put(m, Double.class, Double.TYPE, BasicTypeID.DOUBLE);
        RecipeComponentBracketHandler.put(m, Character.class, Character.TYPE, BasicTypeID.CHAR);
        return m;
    });

    @ZenCodeType.Method(value="bracket")
    public static <T> IRecipeComponent<T> bracket(ResourceLocation name) {
        return IRecipeComponent.find(name);
    }

    public static Supplier<Stream<String>> getDumperData() {
        return () -> CraftTweakerAPI.getRegistry().getAllRecipeComponents().stream().map(IRecipeComponent::getCommandString).distinct();
    }

    private static void put(Map<Class<?>, String> m, Class<?> boxed, Class<?> primitive, BasicTypeID id) {
        m.put(primitive, id.name);
        m.put(boxed, id.name + "?");
    }

    @Override
    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        ResourceLocation rl;
        String name = ParseUtil.readBracketContent(position, tokens);
        try {
            rl = ResourceLocation.parse((String)name);
        }
        catch (ResourceLocationException e) {
            throw new ParseException(position, "Invalid name, expected <recipecomponent:modid:location>", e);
        }
        IRecipeComponent component = IRecipeComponent.find(rl);
        if (component == null) {
            throw new ParseException(position, "Unknown component " + String.valueOf(rl));
        }
        TypeToken token = component.objectType();
        return this.call(position, token, rl);
    }

    private <T> ParsedExpression call(CodePosition position, TypeToken<T> token, ResourceLocation rl) throws ParseException {
        ParsedExpression thisClass = this.compileClassCall(position);
        ParsedExpressionMember method = new ParsedExpressionMember(position, thisClass, BRACKET_METHOD_NAME, List.of());
        ParsedExpression argument = ParseUtil.createResourceLocationArgument(position, rl);
        IParsedType generic = this.makeParsedType(token, position);
        ParsedCallArguments arguments = new ParsedCallArguments(List.of(generic), List.of(argument));
        return new ParsedExpressionCall(position, method, arguments);
    }

    private ParsedExpression compileClassCall(CodePosition position) {
        return ParseUtil.staticMemberExpression(position, this.className(this.getClass()));
    }

    private <T> IParsedType makeParsedType(TypeToken<T> token, CodePosition position) throws ParseException {
        try {
            return ParseUtil.readParsedType(this.makeParsedType(token.getType()), position);
        }
        catch (IllegalStateException | UnsupportedOperationException | NoSuchElementException e) {
            throw new ParseException(position, "Unable to resolve component generic " + String.valueOf(token) + " due to an error", e);
        }
    }

    private String makeParsedType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType generic = (ParameterizedType)type;
            String rawType = this.makeParsedType(generic.getRawType());
            return Arrays.stream(generic.getActualTypeArguments()).map(this::makeParsedType).collect(Collectors.joining(", ", rawType + "<", ">"));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return this.className(clazz);
        }
        if (type instanceof TypeVariable) {
            throw new UnsupportedOperationException("Unresolved generic identified " + String.valueOf(type));
        }
        throw new IllegalStateException();
    }

    private String className(Class<?> clazz) {
        String stdlibType = STDLIB_TYPES.get(clazz);
        if (stdlibType != null) {
            return stdlibType;
        }
        IScriptLoader loader = CraftTweakerAPI.getScriptRunManager().currentRunInfo().loader();
        IZenClassRegistry registry = CraftTweakerAPI.getRegistry().getZenClassRegistry();
        return registry.getNameFor(loader, clazz).orElseThrow();
    }
}

