/*
 * Decompiled with CFR 0.152.
 */
package artifacts.platform;

import artifacts.component.AbilityToggles;
import artifacts.component.SwimData;
import artifacts.integration.EquipmentIntegrationUtils;
import artifacts.integration.client.ClientEquipmentIntegrationUtils;
import artifacts.integration.impl.accessories.AccessoriesClientIntegration;
import artifacts.integration.impl.accessories.AccessoriesIntegration;
import artifacts.integration.impl.trinkets.TrinketsClientIntegration;
import artifacts.integration.impl.trinkets.TrinketsIntegration;
import artifacts.platform.PlatformServices;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface PlatformHelper {
    @Nullable
    public AbilityToggles getAbilityToggles(LivingEntity var1);

    @Nullable
    public SwimData getSwimData(LivingEntity var1);

    public Holder<Attribute> getSwimSpeedAttribute();

    public Holder<Attribute> registerAttribute(String var1, Supplier<? extends Attribute> var2);

    public boolean isEyeInWater(Player var1);

    public boolean areBootsHidden(LivingEntity var1);

    public boolean isFishingRod(ItemStack var1);

    public Path getConfigDir();

    public void registryEntryAddCallback(Consumer<Item> var1);

    public boolean isModLoaded(String var1);

    default public void setupIntegrations() {
        if (PlatformServices.platformHelper.isModLoaded("trinkets") && !PlatformServices.platformHelper.isModLoaded("tclayer")) {
            EquipmentIntegrationUtils.registerIntegration(new TrinketsIntegration());
        }
        if (PlatformServices.platformHelper.isModLoaded("accessories")) {
            EquipmentIntegrationUtils.registerIntegration(new AccessoriesIntegration());
        }
    }

    default public void setupClientIntegrations() {
        if (PlatformServices.platformHelper.isModLoaded("trinkets") && !PlatformServices.platformHelper.isModLoaded("tclayer")) {
            ClientEquipmentIntegrationUtils.registerIntegration(new TrinketsClientIntegration());
        }
        if (PlatformServices.platformHelper.isModLoaded("accessories")) {
            ClientEquipmentIntegrationUtils.registerIntegration(new AccessoriesClientIntegration());
        }
    }
}

