/*
 * Decompiled with CFR 0.152.
 */
package artifacts.network;

import artifacts.Artifacts;
import artifacts.ability.TeleportOnDeathAbility;
import artifacts.registry.ModItems;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record ChorusTotemUsedPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChorusTotemUsedPacket> TYPE = new CustomPacketPayload.Type(Artifacts.id("chorus_totem_used"));
    public static final StreamCodec<FriendlyByteBuf, ChorusTotemUsedPacket> CODEC = StreamCodec.unit((Object)new ChorusTotemUsedPacket());

    void apply(NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        ItemStack totem = TeleportOnDeathAbility.findTotem((LivingEntity)player);
        if (totem.isEmpty()) {
            totem = new ItemStack((ItemLike)ModItems.CHORUS_TOTEM.value());
        }
        Minecraft.getInstance().gameRenderer.displayItemActivation(totem);
        player.level().playSound(context.getPlayer(), (Entity)context.getPlayer(), SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

