/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.integration.curios;

import artifacts.event.ArtifactEvents;
import artifacts.integration.EquipmentIntegration;
import artifacts.item.WearableArtifactItem;
import artifacts.neoforge.integration.curios.WearableArtifactCurio;
import artifacts.platform.PlatformServices;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.NeoForge;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosIntegration
implements EquipmentIntegration {
    @Override
    public void setup() {
        PlatformServices.platformHelper.registryEntryAddCallback(item -> {
            if (item instanceof WearableArtifactItem) {
                WearableArtifactItem wearableArtifactItem = (WearableArtifactItem)((Object)item);
                CuriosApi.registerCurio((Item)wearableArtifactItem, (ICurioItem)new WearableArtifactCurio(wearableArtifactItem));
            }
        });
        NeoForge.EVENT_BUS.addListener(event -> ArtifactEvents.onItemChanged(event.getEntity(), event.getFrom(), event.getTo()));
    }

    @Override
    public Stream<ItemStack> findAllEquippedBy(LivingEntity entity, Predicate<ItemStack> predicate) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(inv -> inv.findCurios(predicate)).orElse(List.of()).stream().map(SlotResult::stack);
    }

    @Override
    public void iterateEquippedAccessories(LivingEntity entity, Consumer<ItemStack> consumer) {
        Optional itemHandler = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (itemHandler.isPresent()) {
            for (ICurioStacksHandler stacksHandler : ((ICuriosItemHandler)itemHandler.get()).getCurios().values()) {
                for (int i = 0; i < stacksHandler.getStacks().getSlots(); ++i) {
                    ItemStack item = stacksHandler.getStacks().getStackInSlot(i);
                    if (item.isEmpty()) continue;
                    consumer.accept(item);
                }
            }
        }
    }

    @Override
    public <T> T reduceAccessories(LivingEntity entity, T init, BiFunction<ItemStack, T, T> f) {
        Optional itemHandler = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (itemHandler.isPresent()) {
            for (ICurioStacksHandler stacksHandler : ((ICuriosItemHandler)itemHandler.get()).getCurios().values()) {
                for (int i = 0; i < stacksHandler.getStacks().getSlots(); ++i) {
                    ItemStack item = stacksHandler.getStacks().getStackInSlot(i);
                    if (item.isEmpty()) continue;
                    init = f.apply(item, (ItemStack)init);
                }
            }
        }
        return init;
    }

    @Override
    public boolean equipAccessory(LivingEntity entity, ItemStack stack) {
        Optional optional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (optional.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)optional.get();
            for (Map.Entry entry : handler.getCurios().entrySet()) {
                for (int i = 0; i < ((ICurioStacksHandler)entry.getValue()).getSlots(); ++i) {
                    SlotContext slotContext = new SlotContext((String)entry.getKey(), entity, i, false, true);
                    if (!CuriosApi.isStackValid((SlotContext)slotContext, (ItemStack)stack) || !((ICurioStacksHandler)entry.getValue()).getStacks().getStackInSlot(i).isEmpty()) continue;
                    ((ICurioStacksHandler)entry.getValue()).getStacks().setStackInSlot(i, stack);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String name() {
        return "curios";
    }
}

