/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.integration.curios;

import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.client.item.renderer.GloveArtifactRenderer;
import artifacts.integration.client.ClientEquipmentIntegration;
import artifacts.item.WearableArtifactItem;
import artifacts.mixin.accessors.client.LivingEntityRendererAccessor;
import artifacts.registry.ModLootTables;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.client.render.CuriosLayer;

public class CuriosClientIntegration
implements ClientEquipmentIntegration {
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        Set<EntityType<?>> entities = ModLootTables.ENTITY_EQUIPMENT.keySet();
        block0: for (EntityType<?> entity : entities) {
            EntityRenderer renderer = event.getRenderer(entity);
            if (renderer == null) continue;
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)renderer;
            for (RenderLayer layer : ((LivingEntityRendererAccessor)livingEntityRenderer).getLayers()) {
                if (!(layer instanceof CuriosLayer)) continue;
                continue block0;
            }
            livingEntityRenderer.addLayer((RenderLayer)new CuriosLayer((RenderLayerParent)livingEntityRenderer));
        }
    }

    @Override
    public void registerArtifactRenderer(Item item, Supplier<ArtifactRenderer> rendererSupplier) {
        CuriosRendererRegistry.register((Item)item, () -> new ArtifactCurioRenderer((ArtifactRenderer)rendererSupplier.get()));
    }

    @Override
    @Nullable
    public ArtifactRenderer getArtifactRenderer(Item item) {
        Object t;
        Optional renderer = CuriosRendererRegistry.getRenderer((Item)item);
        if (renderer.isPresent() && (t = renderer.get()) instanceof ArtifactCurioRenderer) {
            ArtifactCurioRenderer artifactTrinketRenderer = (ArtifactCurioRenderer)t;
            return artifactTrinketRenderer.renderer();
        }
        return null;
    }

    @Override
    public void renderArm(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player, HumanoidArm side) {
        InteractionHand hand = side == player.getMainArm() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.getCurios().values().forEach(stacksHandler -> {
            if (stacksHandler != null) {
                int slot;
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStacks = stacksHandler.getCosmeticStacks();
                int n = slot = hand == InteractionHand.MAIN_HAND ? 0 : 1;
                while (slot < stacks.getSlots()) {
                    GloveArtifactRenderer renderer;
                    ItemStack stack = cosmeticStacks.getStackInSlot(slot);
                    if (stack.isEmpty() && ((Boolean)stacksHandler.getRenders().get(slot)).booleanValue()) {
                        stack = stacks.getStackInSlot(slot);
                    }
                    if (stack.getItem() instanceof WearableArtifactItem && (renderer = GloveArtifactRenderer.getGloveRenderer(stack)) != null) {
                        renderer.renderFirstPersonArm(matrixStack, buffer, light, player, side, stack.hasFoil());
                    }
                    slot += 2;
                }
            }
        }));
    }

    @Override
    public String name() {
        return "curios";
    }

    public record ArtifactCurioRenderer(ArtifactRenderer renderer) implements ICurioRenderer
    {
        public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            this.renderer.render(stack, slotContext.entity(), slotContext.index(), poseStack, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

