/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.data;

import artifacts.Artifacts;
import artifacts.ability.ArtifactAbility;
import artifacts.config.ConfigManager;
import artifacts.neoforge.data.Advancements;
import artifacts.neoforge.data.tags.ItemTags;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModAttributes;
import artifacts.registry.ModEntityTypes;
import artifacts.registry.ModItems;
import artifacts.registry.ModSoundEvents;
import artifacts.registry.ModTags;
import artifacts.registry.RegistryHolder;
import com.google.common.base.CaseFormat;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class Language
extends LanguageProvider {
    public Language(PackOutput output) {
        super(output, "artifacts", "en_us");
    }

    protected void addTranslations() {
        Artifacts.setupConfigs();
        this.addMiscTranslations();
        this.addAbilities();
        this.addAttributes();
        this.addEntities();
        this.addConfigs();
        this.addItems();
        this.addTags();
        this.addTooltips();
        Advancements.TRANSLATIONS.forEach((arg_0, arg_1) -> ((Language)this).add(arg_0, arg_1));
    }

    public void override(String key, String value) {
        try {
            this.add(key, value);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void addMiscTranslations() {
        this.add("artifacts.creative_tab", "Artifacts");
        this.add("artifacts.key.helium_flamingo.activate", "Activate Helium Flamingo");
        this.add("artifacts.key.night_vision_goggles.toggle", "Toggle Night Vision Goggles");
        this.add("artifacts.key.universal_attractor.toggle", "Toggle Universal Attractor");
        this.add("artifacts.key_category", "Artifacts");
        this.add((SoundEvent)ModSoundEvents.FART.value(), "Fart");
        this.add("curios.identifier.feet", "Feet");
        this.add("curios.modifiers.feet", "When on feet:");
    }

    private void addAbilities() {
        this.addAbilityTooltip(ModAbilities.APPLY_MOB_EFFECT_AFTER_DAMAGE, MobEffects.FIRE_RESISTANCE, "Applies a temporary fire resistance effect after taking fire damage");
        this.addAbilityTooltip(ModAbilities.APPLY_MOB_EFFECT_AFTER_DAMAGE, MobEffects.MOVEMENT_SPEED, "Increases the wearer's movement speed after taking damage");
        this.addAbilityTooltip(ModAbilities.APPLY_MOB_EFFECT_AFTER_EATING, MobEffects.DIG_SPEED, "Grants a temporary boost to mining speed after eating food");
        this.addAbilityTooltip(ModAbilities.ATTACKS_ABSORB_DAMAGE, "chance", "The wearer's melee attacks have a chance to absorb health");
        this.addAbilityTooltip(ModAbilities.ATTACKS_ABSORB_DAMAGE, "constant", "Causes the wearer's melee attacks to absorb health");
        this.addAbilityTooltip(ModAbilities.ATTACKS_INFLICT_MOB_EFFECT, MobEffects.WITHER, "chance", "Melee attacks have a chance to inflict a wither effect");
        this.addAbilityTooltip(ModAbilities.ATTACKS_INFLICT_MOB_EFFECT, MobEffects.WITHER, "constant", "Causes the wearer's melee attacks to inflict a wither effect");
        this.addAbilityTooltip(ModAbilities.ATTRACT_ITEMS, "Attracts nearby items");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, ModAttributes.ATTACK_BURNING_DURATION, "Causes the wearer's melee attacks to deal fire damage");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, Attributes.ATTACK_DAMAGE, "Increases damage dealt by the wearer");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, Attributes.ATTACK_KNOCKBACK, "Increases knockback dealt by the wearer");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, Attributes.ATTACK_SPEED, "Increases the wearer's attack speed");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, ModAttributes.DRINKING_SPEED, "Decreases the time it takes to drink items");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, ModAttributes.EATING_SPEED, "Decreases the time it takes to eat items");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, Attributes.FALL_DAMAGE_MULTIPLIER, "Reduces fall damage taken by the wearer");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, ModAttributes.FLATULENCE, "Increases the wearer's flatulence");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, ModAttributes.INVINCIBILITY_TICKS, "Increases the length of invincibility after taking damage");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, Attributes.JUMP_STRENGTH, "Increases the wearer's jump height");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, Attributes.KNOCKBACK_RESISTANCE, "Grants immunity to knockback");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, Attributes.MAX_HEALTH, "Increases the wearer's maximum health");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, ModAttributes.MOUNT_SPEED, "Increases the speed of ridden mounts");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, Attributes.SAFE_FALL_DISTANCE, "Increases the wearer's maximum safe fall distance");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, Attributes.SCALE, "Shrinks the wearer");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, ModAttributes.SLIP_RESISTANCE, "Makes ice less slippery to walk on");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, ModAttributes.MOVEMENT_SPEED_ON_SNOW, "Increases the wearer's walking speed on snow");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, ModAttributes.SPRINTING_SPEED, "Increases the wearer's movement speed while sprinting");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, ModAttributes.SPRINTING_STEP_HEIGHT, "Increases the wearer's step height while sprinting");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, "generic.swim_speed", "Improves agility in water");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, Attributes.BLOCK_BREAK_SPEED, "Increases the wearer's mining speed");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, ModAttributes.ENTITY_EXPERIENCE, "Increases experience dropped by creatures");
        this.addAbilityTooltip(ModAbilities.ATTRIBUTE_MODIFIER, ModAttributes.VILLAGER_REPUTATION, "Decreases the trading prices of villagers");
        this.addAbilityTooltip(ModAbilities.DAMAGE_IMMUNITY, ModTags.IS_HOT_FLOOR.location().getPath(), "Grants protection against hot floor damage");
        this.addAbilityTooltip(ModAbilities.DAMAGE_IMMUNITY, DamageTypeTags.IS_LIGHTNING.location().getPath(), "Grants protection against lightning strikes");
        this.addAbilityTooltip(ModAbilities.DOUBLE_JUMP, "Allows the wearer to double jump");
        this.addAbilityTooltip(ModAbilities.ENDER_PEARLS_COST_HUNGER, "free", "Ender Pearls are not consumed when thrown");
        this.addAbilityTooltip(ModAbilities.ENDER_PEARLS_COST_HUNGER, "cost", "Ender Pearls are not consumed, but cost hunger instead");
        this.addAbilityTooltip(ModAbilities.GROW_PLANTS_AFTER_EATING, "Plants grow after eating when standing on grass");
        this.addAbilityTooltip(ModAbilities.INCREASE_ENCHANTMENT_LEVEL, "fortune", "multiple_levels", "Applies %s extra levels of fortune to mined blocks");
        this.addAbilityTooltip(ModAbilities.INCREASE_ENCHANTMENT_LEVEL, "fortune", "single_level", "Applies an extra level of fortune to mined blocks");
        this.addAbilityTooltip(ModAbilities.INCREASE_ENCHANTMENT_LEVEL, "looting", "multiple_levels", "Applies %s extra levels of looting to killed entities");
        this.addAbilityTooltip(ModAbilities.INCREASE_ENCHANTMENT_LEVEL, "looting", "single_level", "Applies an extra level of looting to killed entities");
        this.addAbilityTooltip(ModAbilities.INCREASE_ENCHANTMENT_LEVEL, "luck_of_the_sea", "multiple_levels", "Applies %s extra levels of Luck of the Sea when fishing");
        this.addAbilityTooltip(ModAbilities.INCREASE_ENCHANTMENT_LEVEL, "luck_of_the_sea", "single_level", "Applies an extra Luck of the Sea when fishing");
        this.addAbilityTooltip(ModAbilities.INCREASE_ENCHANTMENT_LEVEL, "lure", "multiple_levels", "Applies %s extra levels of Lure when fishing");
        this.addAbilityTooltip(ModAbilities.INCREASE_ENCHANTMENT_LEVEL, "lure", "single_level", "Applies an extra level of Lure when fishing");
        this.addAbilityTooltip(ModAbilities.LIMITED_WATER_BREATHING, "infinite", "Allows the wearer to breathe underwater");
        this.addAbilityTooltip(ModAbilities.LIMITED_WATER_BREATHING, "limited", "Allows the wearer to breathe underwater for a limited amount of time");
        this.addAbilityTooltip(ModAbilities.MOB_EFFECT, "invisibility", "Turns the wearer invisible");
        this.addAbilityTooltip(ModAbilities.NIGHT_VISION, "full", "Allows the wearer to see in the dark");
        this.addAbilityTooltip(ModAbilities.NIGHT_VISION, "partial", "Allows the wearer to see in the dark slightly");
        this.addAbilityTooltip(ModAbilities.NULLIFY_ENDER_PEARL_DAMAGE, "Ender Pearls deal no damage");
        this.addAbilityTooltip(ModAbilities.REMOVE_BAD_EFFECTS, "Greatly reduces the duration of negative effects");
        this.addAbilityTooltip(ModAbilities.REPLENISH_HUNGER_ON_GRASS, "Slowly replenishes hunger while walking on grass");
        this.addAbilityTooltip(ModAbilities.SCARE_CREEPERS, "Creepers avoid the wearer");
        this.addAbilityTooltip(ModAbilities.SET_ATTACKERS_ON_FIRE, "fire_resistance", "Grants fire resistance after lighting an attacker on fire");
        this.addAbilityTooltip(ModAbilities.SET_ATTACKERS_ON_FIRE, "chance", "Has a chance to light attackers on fire");
        this.addAbilityTooltip(ModAbilities.SET_ATTACKERS_ON_FIRE, "constant", "Attacking entities are lit on fire");
        this.addAbilityTooltip(ModAbilities.SINKING, "Allows the wearer to move freely in water");
        this.addAbilityTooltip(ModAbilities.SMELT_ORES, "Automatically smelts mined ores");
        this.addAbilityTooltip(ModAbilities.SNEAK_ON_FLUIDS, "lava", "Allows the wearer to stand on lava while sneaking");
        this.addAbilityTooltip(ModAbilities.SPRINT_ON_FLUIDS, "Allows the wearer to walk on fluids while sprinting");
        this.addAbilityTooltip(ModAbilities.STRIKE_ATTACKERS_WITH_LIGHTNING, "chance", "Has a chance to strike attackers with lightning");
        this.addAbilityTooltip(ModAbilities.STRIKE_ATTACKERS_WITH_LIGHTNING, "constant", "Attacking entities are struck by lightning");
        this.addAbilityTooltip(ModAbilities.SWIM_IN_AIR, "keymapping", "Press %s while in the air to start swimming");
        this.addAbilityTooltip(ModAbilities.SWIM_IN_AIR, "swimming", "Allows the wearer to swim in the air for a limited period of time");
        this.addAbilityTooltip(ModAbilities.TELEPORT_ON_DEATH, "chance", "A fatal hit has a chance to teleport you somewhere else instead");
        this.addAbilityTooltip(ModAbilities.TELEPORT_ON_DEATH, "constant", "A fatal hit teleports you somewhere else instead");
        this.addAbilityTooltip(ModAbilities.TELEPORT_ON_DEATH, "not_consumed", "Not consumed on use");
        this.addAbilityTooltip(ModAbilities.THORNS, "chance", "Has a chance to damage attackers");
        this.addAbilityTooltip(ModAbilities.THORNS, "constant", "Attacking entities are damaged as well");
        this.addAbilityTooltip(ModAbilities.UPGRADE_TOOL_TIER, "Increases the wearer's base mining level to %s");
        this.addAbilityTooltip(ModAbilities.WALK_ON_POWDER_SNOW, "Allows the wearer to walk on Powder Snow");
    }

    private void addAttributes() {
        for (RegistryHolder<Attribute, ?> attribute : ModAttributes.ATTRIBUTES) {
            this.add(((Attribute)attribute.get()).getDescriptionId(), Language.fromSnakeCasedString(attribute.unwrapKey().orElseThrow().location().getPath().split("\\.")[1]));
        }
        this.add("generic.swim_speed", "Swim Speed");
    }

    private void addEntities() {
        for (RegistrySupplier entityType : ModEntityTypes.ENTITY_TYPES) {
            this.add(((EntityType)entityType.get()).getDescriptionId(), Language.fromSnakeCasedString(entityType.getId().getPath()));
        }
        this.add((SoundEvent)ModSoundEvents.MIMIC_CLOSE.value(), "Mimic closes");
        this.add((SoundEvent)ModSoundEvents.MIMIC_DEATH.value(), "Mimic dies");
        this.add((SoundEvent)ModSoundEvents.MIMIC_HURT.value(), "Mimic hurts");
        this.add((SoundEvent)ModSoundEvents.MIMIC_OPEN.value(), "Mimic hops");
    }

    private void addConfigs() {
        this.add(Language.configTitle(new String[0]), "Artifacts Config");
        this.add("artifacts.config.enabled.title", "Enabled");
        this.add("artifacts.config.cooldown.title", "Cooldown");
        for (ConfigManager config : Artifacts.CONFIG.configs) {
            this.add(Language.configTitle(config.getName()), Language.fromCamelCasedString(config.getName()));
            this.addConfigNames(config);
            this.addConfigTooltips(config);
        }
    }

    private void addConfigNames(ConfigManager config) {
        config.getValues().forEach((key, value) -> {
            String[] words = ((String)key).split("\\.");
            String name = words[words.length - 1];
            if (!name.equals("cooldown") && !name.equals("enabled")) {
                String translation = Language.fromCamelCasedString(name);
                key = config.getName() + "." + (String)key;
                this.add(Language.configTitle(new String[]{key}), translation);
                StringBuilder categoryKey = new StringBuilder(config.getName());
                for (int i = 0; i < words.length - 1; ++i) {
                    categoryKey.append('.').append(words[i]);
                    if (BuiltInRegistries.ITEM.containsKey(Artifacts.id(words[i]))) continue;
                    this.override(Language.configTitle(categoryKey.toString()), Language.fromSnakeCasedString(words[i]));
                }
            }
        });
    }

    private void addConfigTooltips(ConfigManager config) {
        config.getValues().forEach((key, value) -> {
            List<String> tooltips = config.getDescription((String)key);
            key = config.getName() + "." + (String)key;
            if (tooltips.size() == 1) {
                this.add(Language.configDescription(new String[]{key}), tooltips.getFirst());
            } else {
                for (int i = 0; i < tooltips.size(); ++i) {
                    this.add(Language.concat(Language.configDescription(new String[]{key}), Integer.toString(i)), tooltips.get(i));
                }
            }
        });
    }

    private void addItems() {
        for (Holder holder : ModItems.ITEMS) {
            this.add((Item)holder.value(), Language.fromSnakeCasedString(((ResourceKey)holder.unwrapKey().orElseThrow()).location().getPath()));
        }
        this.override(((Item)ModItems.ANGLERS_HAT.value()).getDescriptionId(), "Angler's Hat");
        this.override(((Item)ModItems.AQUA_DASHERS.value()).getDescriptionId(), "Aqua-Dashers");
    }

    private void addTags() {
        this.add(ItemTags.ARTIFACTS, "Artifacts");
        this.add(ItemTags.ALL, "Any Slot Equipable Artifacts");
        this.add(ItemTags.BELT, "Belt Slot Equipable Artifacts");
        this.add(ItemTags.FEET, "Feet Slot Equipable Artifacts");
        this.add(ItemTags.HANDS, "Hands Slot Equipable Artifacts");
        this.add(ItemTags.HEAD, "Head Slot Equipable Artifacts");
        this.add(ItemTags.NECKLACE, "Necklace Slot Equipable Artifacts");
        this.add(ModTags.ANTIDOTE_VESSEL_CANCELLABLE, "Antidote Vessel Cancellable");
        this.add(ModTags.CAMPSITE_CHESTS, "Campsite Chests");
        this.add(ModTags.CREEPERS, "Creepers");
        this.add(ModTags.MINEABLE_WITH_DIGGING_CLAWS, "Mineable With Digging Claws");
        this.add(ModTags.ROOTED_BOOTS_GRASS, "Rooted Boots Grass");
        this.add(ModTags.SNOW_LAYERS, "Snow Layers");
    }

    private void addTooltips() {
        this.tooltip("attacks_inflict.chance", "Attacks have a chance to inflict:");
        this.tooltip("attacks_inflict.constant", "Attacks inflict:");
        this.tooltip("cooldown", "+Cooldown (%s)");
        this.tooltip("cosmetic", "Cosmetic");
        this.tooltip("cosmetics_disabled", "Cosmetics disabled (right-click to toggle)");
        this.tooltip("cosmetics_enabled", "Cosmetics enabled (right-click to toggle)");
        this.tooltip("item.everlasting_food", "Not consumed when eaten");
        this.tooltip("item.novelty_drinking_hat", "'Hey! I'm #1, and I let gravity do my drinking!'");
        this.tooltip("item.umbrella.glider", "Slows your fall when held");
        this.tooltip("item.umbrella.shield", "Can be used as a shield");
        this.tooltip("missing_dependency", "Install Curios, Trinkets or Accessories to use this item");
        this.tooltip("per_food_point_restored", "For every food point restored:");
        this.tooltip("plus_mob_effect", "+%s");
        this.tooltip("toggle_keymapping", "Press %s to toggle");
        this.tooltip("tool_tier.none", "none");
        this.tooltip("tool_tier.wood", "wood");
        this.tooltip("tool_tier.stone", "stone");
        this.tooltip("tool_tier.iron", "iron");
        this.tooltip("tool_tier.diamond", "diamond");
        this.tooltip("tool_tier.netherite", "netherite");
        this.tooltip("when_hurt", "When hurt:");
        this.tooltip("when_hurt.is_fire", "When hurt by Fire:");
    }

    private void add(SoundEvent soundEvent, String value) {
        this.add("%s.subtitles.%s", BuiltInRegistries.SOUND_EVENT.getKey((Object)soundEvent), value);
    }

    private void add(String key, ResourceLocation id, String value) {
        this.add(key.formatted(id.getNamespace(), id.getPath()), value);
    }

    private void addAbilityTooltip(Holder<? extends ArtifactAbility.Type<?>> type, Holder<?> holder, String ... s) {
        ArrayList<String> list = new ArrayList<String>(List.of(s));
        list.addFirst(((ResourceKey)holder.unwrapKey().get()).location().getPath());
        this.addAbilityTooltip(type, (String[])list.toArray(String[]::new));
    }

    private void addAbilityTooltip(Holder<? extends ArtifactAbility.Type<?>> type, String ... s) {
        StringBuilder key = new StringBuilder("%s.tooltip.ability.%s");
        for (int i = 0; i < s.length - 1; ++i) {
            key.append('.').append(s[i]);
        }
        this.add(key.toString(), ModAbilities.getRegistry().getKey((Object)((ArtifactAbility.Type)type.value())), s[s.length - 1]);
    }

    private void tooltip(String key, String value) {
        this.add("%s.tooltip.%s".formatted("artifacts", key), value);
    }

    private static String fromCamelCasedString(String string) {
        return Language.fromSnakeCasedString(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, string));
    }

    private static String fromSnakeCasedString(String string) {
        String[] words = string.split("_");
        for (int i = 0; i < words.length; ++i) {
            words[i] = Character.toUpperCase(words[i].charAt(0)) + words[i].substring(1);
        }
        return Strings.join((String[])words, (String)" ").replace(" A ", " a ").replace(" An ", " an ").replaceFirst(" In ", " in ").replace(" Of ", " of ").replace(" On ", " on ").replaceFirst(" Per ", " per ").replace(" The ", " the ");
    }

    private static String configDescription(String ... names) {
        return Language.key("config", Language.concat(names), "description");
    }

    private static String configTitle(String ... names) {
        return Language.key("config", Language.concat(names), "title");
    }

    private static String key(String ... names) {
        return Language.concat("artifacts", Language.concat(names));
    }

    private static String concat(String ... names) {
        if (names.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(names[0]);
        for (int i = 1; i < names.length; ++i) {
            if (names[i].isEmpty()) continue;
            builder.append('.').append(names[i]);
        }
        return builder.toString();
    }
}

