/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.client;

import artifacts.Artifacts;
import artifacts.integration.EquipmentIntegrationUtils;
import artifacts.item.WearableArtifactItem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.mutable.MutableInt;

public class ArtifactCooldownOverlayRenderer {
    public static void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int start;
        int step;
        Entity entity;
        if (!Artifacts.CONFIG.client.enableCooldownOverlay.get().booleanValue() || !((entity = Minecraft.getInstance().getCameraEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int y = guiGraphics.guiHeight() - 16 - 3;
        int cooldownOverlayOffset = Artifacts.CONFIG.client.cooldownOverlayOffset.get();
        if (cooldownOverlayOffset < 0) {
            step = -20;
            start = guiGraphics.guiWidth() / 2 - 91 - 16 + cooldownOverlayOffset;
        } else {
            step = 20;
            start = guiGraphics.guiWidth() / 2 + 91 + cooldownOverlayOffset;
        }
        MutableInt k = new MutableInt(0);
        EquipmentIntegrationUtils.iterateEquippedAccessories((LivingEntity)player, stack -> {
            if (!stack.isEmpty() && stack.getItem() instanceof WearableArtifactItem && player.getCooldowns().isOnCooldown(stack.getItem())) {
                int x = start + step * k.intValue();
                k.add(1);
                guiGraphics.renderItem((LivingEntity)player, stack, x, y, k.intValue() + 1);
                guiGraphics.renderItemDecorations(Minecraft.getInstance().font, stack, x, y);
            }
        });
    }
}

