/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.ability.nightvision.client;

import artifacts.ability.ArtifactAbility;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @ModifyReturnValue(method={"getNightVisionScale(Lnet/minecraft/world/entity/LivingEntity;F)F"}, at={@At(value="RETURN")})
    private static float getNightVisionScale(float original, LivingEntity entity, float f) {
        MobEffectInstance effect = entity.getEffect(MobEffects.NIGHT_VISION);
        if (effect == null || !effect.endsWithin(60)) {
            return original;
        }
        double scale = AbilityHelper.maxDouble((ArtifactAbility.Type)ModAbilities.NIGHT_VISION.value(), entity, ability -> (Double)ability.strength().get(), false);
        if (scale == 0.0) {
            return original;
        }
        return Mth.lerp((float)(Math.max(0.0f, (float)effect.getDuration() - f - 40.0f) / 20.0f), (float)((float)scale), (float)original);
    }
}

