/*
 * Decompiled with CFR 0.152.
 */
package artifacts.integration.impl.trinkets;

import artifacts.event.ArtifactEvents;
import artifacts.integration.EquipmentIntegration;
import artifacts.item.WearableArtifactItem;
import artifacts.platform.PlatformServices;
import artifacts.util.DamageSourceHelper;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.event.TrinketEquipCallback;
import dev.emi.trinkets.api.event.TrinketUnequipCallback;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TrinketsIntegration
implements EquipmentIntegration {
    @Override
    public void setup() {
        PlatformServices.platformHelper.registryEntryAddCallback(item -> {
            if (item instanceof WearableArtifactItem) {
                WearableArtifactItem wearableArtifactItem = (WearableArtifactItem)((Object)item);
                TrinketsApi.registerTrinket((Item)item, (Trinket)new WearableArtifactTrinket(wearableArtifactItem));
            }
        });
        TrinketEquipCallback.EVENT.register((stack, slot, entity) -> ArtifactEvents.onItemChanged(entity, ItemStack.EMPTY, stack));
        TrinketUnequipCallback.EVENT.register((stack, slot, entity) -> ArtifactEvents.onItemChanged(entity, stack, ItemStack.EMPTY));
    }

    @Override
    public Stream<ItemStack> findAllEquippedBy(LivingEntity entity, Predicate<ItemStack> predicate) {
        return TrinketsApi.getTrinketComponent((LivingEntity)entity).map(TrinketComponent::getAllEquipped).orElse(List.of()).stream().map(Tuple::getB);
    }

    @Override
    public void iterateEquippedAccessories(LivingEntity entity, Consumer<ItemStack> consumer) {
        TrinketsApi.getTrinketComponent((LivingEntity)entity).ifPresent(component -> {
            for (Map map : component.getInventory().values()) {
                for (TrinketInventory inventory : map.values()) {
                    for (int i = 0; i < inventory.getContainerSize(); ++i) {
                        ItemStack item = inventory.getItem(i);
                        if (item.isEmpty()) continue;
                        consumer.accept(item);
                    }
                }
            }
        });
    }

    @Override
    public <T> T reduceAccessories(LivingEntity entity, T init, BiFunction<ItemStack, T, T> f) {
        Optional component = TrinketsApi.getTrinketComponent((LivingEntity)entity);
        if (component.isPresent()) {
            for (Map map : ((TrinketComponent)component.get()).getInventory().values()) {
                for (TrinketInventory inventory : map.values()) {
                    for (int i = 0; i < inventory.getContainerSize(); ++i) {
                        ItemStack item = inventory.getItem(i);
                        if (item.isEmpty()) continue;
                        init = f.apply(item, (ItemStack)init);
                    }
                }
            }
        }
        return init;
    }

    @Override
    public boolean equipAccessory(LivingEntity entity, ItemStack stack) {
        return TrinketItem.equipItem((LivingEntity)entity, (ItemStack)stack);
    }

    @Override
    public String name() {
        return "trinkets";
    }

    public record WearableArtifactTrinket(WearableArtifactItem item) implements Trinket
    {
        public TrinketEnums.DropRule getDropRule(ItemStack stack, SlotReference slot, LivingEntity entity) {
            if (DamageSourceHelper.shouldDestroyWornItemsOnDeath(entity)) {
                return TrinketEnums.DropRule.DESTROY;
            }
            return super.getDropRule(stack, slot, entity);
        }
    }
}

