/*
 * Decompiled with CFR 0.152.
 */
package artifacts.integration.impl.accessories;

import artifacts.event.ArtifactEvents;
import artifacts.integration.EquipmentIntegration;
import artifacts.item.WearableArtifactItem;
import artifacts.platform.PlatformServices;
import artifacts.util.DamageSourceHelper;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.EquipAction;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.events.AccessoryChangeCallback;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import it.unimi.dsi.fastutil.Pair;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AccessoriesIntegration
implements EquipmentIntegration {
    @Override
    public void setup() {
        PlatformServices.platformHelper.registryEntryAddCallback(item -> {
            if (item instanceof WearableArtifactItem) {
                WearableArtifactItem wearableArtifactItem = (WearableArtifactItem)((Object)item);
                AccessoriesAPI.registerAccessory((Item)item, (Accessory)new WearableArtifactAccessory(wearableArtifactItem));
            }
        });
        AccessoryChangeCallback.EVENT.register((prevStack, currentStack, slotReference, slotStateChange) -> ArtifactEvents.onItemChanged(slotReference.entity(), prevStack, currentStack));
    }

    @Override
    public Stream<ItemStack> findAllEquippedBy(LivingEntity entity, Predicate<ItemStack> predicate) {
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        Stream<ItemStack> stacks = Stream.empty();
        if (capability != null) {
            stacks = capability.getEquipped(predicate).stream().map(SlotEntryReference::stack);
        }
        return stacks;
    }

    @Override
    public void iterateEquippedAccessories(LivingEntity entity, Consumer<ItemStack> consumer) {
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null) {
            capability.getAllEquipped().forEach(slotEntryReference -> consumer.accept(slotEntryReference.stack()));
        }
    }

    @Override
    public <T> T reduceAccessories(LivingEntity entity, T init, BiFunction<ItemStack, T, T> f) {
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null) {
            for (SlotEntryReference slotEntryReference : capability.getAllEquipped()) {
                init = f.apply(slotEntryReference.stack(), (ItemStack)init);
            }
        }
        return init;
    }

    @Override
    public boolean equipAccessory(LivingEntity entity, ItemStack stack) {
        Pair possibleLocation;
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null && (possibleLocation = capability.canEquipAccessory(stack, false)) != null) {
            ((EquipAction)possibleLocation.second()).equipStack(stack);
            return true;
        }
        return false;
    }

    @Override
    public String name() {
        return "accessories";
    }

    public record WearableArtifactAccessory(WearableArtifactItem item) implements Accessory
    {
        public DropRule getDropRule(ItemStack stack, SlotReference reference, DamageSource source) {
            if (DamageSourceHelper.shouldDestroyWornItemsOnDeath(reference.entity())) {
                return DropRule.DESTROY;
            }
            return super.getDropRule(stack, reference, source);
        }

        public SoundEventData getEquipSound(ItemStack stack, SlotReference reference) {
            return new SoundEventData(Holder.direct((Object)this.item.getEquipSound()), 1.0f, this.item.getEquipSoundPitch());
        }

        public boolean canEquipFromUse(ItemStack stack) {
            return stack.get(DataComponents.FOOD) == null;
        }
    }
}

