/*
 * Decompiled with CFR 0.152.
 */
package artifacts.integration.impl.accessories;

import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.client.item.renderer.GloveArtifactRenderer;
import artifacts.integration.client.ClientEquipmentIntegration;
import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AccessoriesClientIntegration
implements ClientEquipmentIntegration {
    @Override
    public void registerArtifactRenderer(Item item, Supplier<ArtifactRenderer> rendererSupplier) {
        AccessoriesRendererRegistry.registerRenderer((Item)item, () -> new ArtifactAccessoryRenderer((ArtifactRenderer)rendererSupplier.get()));
    }

    @Override
    @Nullable
    public ArtifactRenderer getArtifactRenderer(Item item) {
        AccessoryRenderer renderer = AccessoriesRendererRegistry.getRender((Item)item);
        if (renderer instanceof ArtifactAccessoryRenderer) {
            ArtifactAccessoryRenderer artifactAccessoryRenderer = (ArtifactAccessoryRenderer)renderer;
            return artifactAccessoryRenderer.renderer();
        }
        return null;
    }

    @Override
    public void renderArm(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player, HumanoidArm side) {
    }

    @Override
    public String name() {
        return "accessories";
    }

    public record ArtifactAccessoryRenderer(ArtifactRenderer renderer) implements AccessoryRenderer
    {
        public <M extends LivingEntity> void render(ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            this.renderer.render(stack, reference.entity(), reference.slot(), matrices, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }

        public <M extends LivingEntity> void renderOnFirstPerson(HumanoidArm side, ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light) {
            LivingEntity livingEntity = reference.entity();
            if (!(livingEntity instanceof LocalPlayer)) {
                return;
            }
            LocalPlayer player = (LocalPlayer)livingEntity;
            InteractionHand hand = side == player.getMainArm() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            GloveArtifactRenderer gloveRenderer = GloveArtifactRenderer.getGloveRenderer(stack);
            if (gloveRenderer != null && reference.slot() % 2 == (hand == InteractionHand.MAIN_HAND ? 0 : 1)) {
                gloveRenderer.renderFirstPersonArm(matrices, multiBufferSource, light, (AbstractClientPlayer)reference.entity(), side, stack.hasFoil());
            }
        }
    }
}

