/*
 * Decompiled with CFR 0.152.
 */
package artifacts.entity;

import artifacts.Artifacts;
import artifacts.registry.ModSoundEvents;
import java.util.EnumSet;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;

public class MimicEntity
extends Mob
implements Enemy {
    public static final ResourceKey<LootTable> LOOT_TABLE = Artifacts.key(Registries.LOOT_TABLE, "entities/mimic");
    public int ticksInAir;
    public int attackCooldown;
    public boolean isDormant;
    public Direction facing;

    public MimicEntity(EntityType<? extends MimicEntity> type, Level world) {
        super(type, world);
        this.moveControl = new MimicMovementController(this);
        this.xpReward = 10;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.8).add(Attributes.MOVEMENT_SPEED, 0.8).add(Attributes.ATTACK_DAMAGE, 5.0);
    }

    public void setFacing(Direction facing) {
        MoveControl moveControl;
        this.facing = facing;
        if (facing != null && (moveControl = this.getMoveControl()) instanceof MimicMovementController) {
            MimicMovementController controller = (MimicMovementController)moveControl;
            controller.setDirection(facing.toYRot(), false);
        }
    }

    public void setDormant(boolean isDormant) {
        this.isDormant = isDormant;
        if (!isDormant) {
            this.facing = null;
        }
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal(this));
        this.goalSelector.addGoal(2, (Goal)new AttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new FaceRandomGoal(this));
        this.goalSelector.addGoal(5, (Goal)new HopGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 1, true, false, entity -> !this.isDormant || (double)this.distanceTo((Entity)entity) < this.getAttribute(Attributes.FOLLOW_RANGE).getValue() / 2.5));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("ticksInAir", this.ticksInAir);
        compound.putBoolean("isDormant", this.isDormant);
        if (this.facing != null) {
            compound.putString("facing", this.facing.name());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.ticksInAir = compound.getInt("ticksInAir");
        if (compound.contains("facing")) {
            this.setFacing(Direction.byName((String)compound.getString("facing").toLowerCase()));
        } else {
            this.setFacing(null);
        }
        this.setDormant(compound.getBoolean("isDormant"));
    }

    public void tick() {
        super.tick();
        if (this.isInWater()) {
            this.ticksInAir = 0;
            if (this.isDormant) {
                this.setDormant(false);
            }
        } else if (!this.onGround()) {
            ++this.ticksInAir;
        } else if (this.ticksInAir > 0) {
            this.playSound(this.getLandingSound(), this.getSoundVolume(), this.getVoicePitch());
            this.ticksInAir = 0;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    public void playerTouch(Player player) {
        if (this.attackCooldown <= 0 && player.level().getDifficulty() != Difficulty.PEACEFUL && this.isAlive() && this.isWithinMeleeAttackRange((LivingEntity)player) && this.hasLineOfSight((Entity)player)) {
            Level level;
            this.attackCooldown = 20;
            DamageSource damageSource = this.damageSources().mobAttack((LivingEntity)this);
            if (player.hurt(damageSource, (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue()) && (level = this.level()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)level2, (Entity)player, (DamageSource)damageSource);
            }
        }
    }

    public void setTarget(LivingEntity entity) {
        this.setDormant(false);
        super.setTarget(entity);
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.setTarget((LivingEntity)player);
        }
        if (this.ticksInAir <= 0 && source.is(DamageTypeTags.IS_PROJECTILE) && !source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            this.playSound((SoundEvent)ModSoundEvents.MIMIC_HURT.value(), this.getSoundVolume(), this.getVoicePitch());
            return false;
        }
        if (this.onGround() && this.getRandom().nextBoolean() && (entity = this.getMoveControl()) instanceof MimicMovementController) {
            MimicMovementController controller = (MimicMovementController)entity;
            controller.setDirection(this.getRandom().nextInt(4) * 90, true);
        }
        return super.hurt(source, amount);
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.MIMIC_HURT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.MIMIC_DEATH.value();
    }

    protected SoundEvent getJumpingSound() {
        return (SoundEvent)ModSoundEvents.MIMIC_OPEN.value();
    }

    protected SoundEvent getLandingSound() {
        return (SoundEvent)ModSoundEvents.MIMIC_CLOSE.value();
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return LOOT_TABLE;
    }

    protected static class MimicMovementController
    extends MoveControl {
        private final MimicEntity mimic;
        private float rotationDegrees;
        private int jumpDelay;

        public MimicMovementController(MimicEntity mimic) {
            super((Mob)mimic);
            this.mimic = mimic;
            this.rotationDegrees = 180.0f * mimic.getYRot() / (float)Math.PI;
            this.jumpDelay = mimic.random.nextInt(320) + 640;
        }

        public void setDirection(float rotation, boolean shouldJump) {
            this.rotationDegrees = rotation;
            if (shouldJump && this.jumpDelay > 10) {
                this.jumpDelay = 10;
            }
        }

        public void setSpeed(double speed) {
            this.speedModifier = speed;
            this.operation = MoveControl.Operation.MOVE_TO;
        }

        public void tick() {
            this.mimic.yHeadRot = this.mimic.yBodyRot = this.rotlerp(this.mimic.getYRot(), this.rotationDegrees, 90.0f);
            this.mimic.setYRot(this.mimic.yHeadRot);
            if (this.operation != MoveControl.Operation.MOVE_TO) {
                this.mimic.setZza(0.0f);
            } else {
                this.operation = MoveControl.Operation.WAIT;
                if (this.mimic.onGround()) {
                    this.mimic.setSpeed((float)(this.speedModifier * this.mimic.getAttribute(Attributes.MOVEMENT_SPEED).getValue()));
                    if (this.jumpDelay-- > 0) {
                        this.mimic.zza = 0.0f;
                        this.mimic.xxa = 0.0f;
                        this.mimic.setSpeed(0.0f);
                    } else {
                        this.jumpDelay = this.mimic.random.nextInt(320) + 640;
                        this.mimic.jumpControl.jump();
                        this.mimic.playSound(this.mimic.getJumpingSound(), this.mimic.getSoundVolume(), this.mimic.getVoicePitch());
                    }
                } else {
                    this.mimic.setSpeed((float)(this.speedModifier * this.mimic.getAttribute(Attributes.MOVEMENT_SPEED).getValue()));
                }
            }
        }
    }

    protected static class FloatGoal
    extends Goal {
        private final MimicEntity mimic;

        public FloatGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            mimic.getNavigation().setCanFloat(true);
        }

        public boolean canUse() {
            return this.mimic.isInWater() || this.mimic.isInLava();
        }

        public void tick() {
            MoveControl moveControl;
            if (this.mimic.getRandom().nextFloat() < 0.8f) {
                this.mimic.jumpControl.jump();
            }
            if ((moveControl = this.mimic.getMoveControl()) instanceof MimicMovementController) {
                MimicMovementController controller = (MimicMovementController)moveControl;
                controller.setSpeed(1.2);
            }
        }
    }

    protected static class AttackGoal
    extends Goal {
        private final MimicEntity mimic;
        private int timeRemaining;

        public AttackGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            Player player;
            LivingEntity target = this.mimic.getTarget();
            return target instanceof Player && (player = (Player)target).isAlive() && player.getCommandSenderWorld().getDifficulty() != Difficulty.PEACEFUL && !player.getAbilities().invulnerable;
        }

        public void start() {
            this.timeRemaining = 300;
            super.start();
        }

        public boolean canContinueToUse() {
            Player player;
            LivingEntity target = this.mimic.getTarget();
            return target instanceof Player && (player = (Player)target).isAlive() && player.getCommandSenderWorld().getDifficulty() != Difficulty.PEACEFUL && !player.getAbilities().invulnerable && --this.timeRemaining > 0;
        }

        public void tick() {
            MoveControl moveControl;
            super.tick();
            if (this.mimic.isDormant) {
                return;
            }
            if (this.mimic.getTarget() != null && (moveControl = this.mimic.getMoveControl()) instanceof MimicMovementController) {
                MimicMovementController controller = (MimicMovementController)moveControl;
                this.mimic.lookAt((Entity)this.mimic.getTarget(), 10.0f, 10.0f);
                controller.setDirection(this.mimic.getYRot(), true);
            }
        }
    }

    protected static class FaceRandomGoal
    extends Goal {
        private final MimicEntity mimic;
        private int chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.mimic.getTarget() == null && (this.mimic.onGround() || this.mimic.isInWater() || this.mimic.isInLava() || this.mimic.hasEffect(MobEffects.LEVITATION));
        }

        public void tick() {
            MoveControl moveControl;
            if (this.mimic.isDormant) {
                return;
            }
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 480 + this.mimic.getRandom().nextInt(320);
                this.chosenDegrees = this.mimic.getRandom().nextInt(4) * 90;
            }
            if ((moveControl = this.mimic.getMoveControl()) instanceof MimicMovementController) {
                MimicMovementController controller = (MimicMovementController)moveControl;
                controller.setDirection(this.chosenDegrees, false);
            }
        }
    }

    protected static class HopGoal
    extends Goal {
        private final MimicEntity mimic;

        public HopGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !this.mimic.isDormant && !this.mimic.isPassenger();
        }

        public void tick() {
            MoveControl moveControl = this.mimic.getMoveControl();
            if (moveControl instanceof MimicMovementController) {
                MimicMovementController controller = (MimicMovementController)moveControl;
                controller.setSpeed(1.0);
            }
        }
    }
}

