/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.retaliation;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.retaliation.RetaliationAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class SetAttackersOnFireAbility
extends RetaliationAbility {
    public static final MapCodec<SetAttackersOnFireAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> SetAttackersOnFireAbility.codecStart(instance).and((App)ValueTypes.DURATION.codec().fieldOf("duration").forGetter(SetAttackersOnFireAbility::fireDuration)).and((App)ValueTypes.BOOLEAN.codec().optionalFieldOf("grant_fire_resistance", Value.of(true)).forGetter(SetAttackersOnFireAbility::grantsFireResistance)).apply((Applicative)instance, SetAttackersOnFireAbility::new));
    public static final StreamCodec<ByteBuf, SetAttackersOnFireAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.FRACTION.streamCodec(), RetaliationAbility::strikeChance, ValueTypes.DURATION.streamCodec(), RetaliationAbility::cooldown, ValueTypes.DURATION.streamCodec(), SetAttackersOnFireAbility::fireDuration, ValueTypes.BOOLEAN.streamCodec(), SetAttackersOnFireAbility::grantsFireResistance, SetAttackersOnFireAbility::new);
    private final Value<Integer> fireDuration;
    private final Value<Boolean> grantsFireResistance;

    public SetAttackersOnFireAbility(Value<Double> strikeChance, Value<Integer> cooldown, Value<Integer> fireDuration, Value<Boolean> grantsFireResistance) {
        super(strikeChance, cooldown);
        this.fireDuration = fireDuration;
        this.grantsFireResistance = grantsFireResistance;
    }

    public Value<Integer> fireDuration() {
        return this.fireDuration;
    }

    public Value<Boolean> grantsFireResistance() {
        return this.grantsFireResistance;
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.SET_ATTACKERS_ON_FIRE.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return super.isNonCosmetic() && (Integer)this.fireDuration().get() > 0;
    }

    @Override
    protected void applyEffect(LivingEntity target, LivingEntity attacker) {
        if (!attacker.fireImmune() && attacker.attackable() && (Integer)this.fireDuration().get() > 0) {
            if (((Boolean)this.grantsFireResistance().get()).booleanValue()) {
                target.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, (Integer)this.fireDuration().get() * 20, 0, false, false, true));
            }
            attacker.igniteForSeconds((float)((Integer)this.fireDuration().get()).intValue());
        }
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        super.addAbilityTooltip(tooltip);
        if (((Boolean)this.grantsFireResistance().get()).booleanValue()) {
            tooltip.add(this.tooltipLine("fire_resistance", new Object[0]));
        }
    }
}

