/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.retaliation;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.util.AbilityHelper;
import artifacts.util.DamageSourceHelper;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class RetaliationAbility
implements ArtifactAbility {
    private final Value<Double> strikeChance;
    private final Value<Integer> cooldown;

    protected static <T extends RetaliationAbility> Products.P2<RecordCodecBuilder.Mu<T>, Value<Double>, Value<Integer>> codecStart(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)ValueTypes.FRACTION.codec().fieldOf("chance").forGetter(RetaliationAbility::strikeChance), (App)ValueTypes.cooldownField().forGetter(RetaliationAbility::cooldown));
    }

    public RetaliationAbility(Value<Double> strikeChance, Value<Integer> cooldown) {
        this.strikeChance = strikeChance;
        this.cooldown = cooldown;
    }

    public Value<Double> strikeChance() {
        return this.strikeChance;
    }

    public Value<Integer> cooldown() {
        return this.cooldown;
    }

    public void onLivingHurt(LivingEntity entity, ItemStack stack, DamageSource damageSource) {
        LivingEntity attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && AbilityHelper.hasAbilityActive(this.getType(), entity) && entity.getRandom().nextDouble() < (Double)this.strikeChance().get()) {
            this.applyEffect(entity, attacker);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if ((Integer)this.cooldown().get() > 0) {
                    player.getCooldowns().addCooldown(stack.getItem(), (Integer)this.cooldown().get() * 20);
                }
            }
        }
    }

    protected abstract void applyEffect(LivingEntity var1, LivingEntity var2);

    @Override
    public boolean isNonCosmetic() {
        return !Mth.equal((double)((Double)this.strikeChance().get()), (double)0.0);
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        if (Mth.equal((double)((Double)this.strikeChance().get()), (double)1.0)) {
            tooltip.add(this.tooltipLine("constant", new Object[0]));
        } else {
            tooltip.add(this.tooltipLine("chance", new Object[0]));
        }
    }
}

