/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.mobeffect;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public interface MobEffectAbility
extends ArtifactAbility {
    public static <T extends MobEffectAbility> Products.P2<RecordCodecBuilder.Mu<T>, Holder<MobEffect>, Value<Integer>> codecStart(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("mob_effect").forGetter(MobEffectAbility::mobEffect), (App)ValueTypes.mobEffectLevelField().forGetter(MobEffectAbility::level));
    }

    public static <T extends MobEffectAbility> Products.P3<RecordCodecBuilder.Mu<T>, Holder<MobEffect>, Value<Integer>, Value<Integer>> codecStartWithDuration(RecordCodecBuilder.Instance<T> instance) {
        return MobEffectAbility.codecStart(instance).and((App)ValueTypes.DURATION.codec().fieldOf("duration").forGetter(MobEffectAbility::duration));
    }

    public Holder<MobEffect> mobEffect();

    public Value<Integer> level();

    public Value<Integer> duration();

    default public int getAmplifier() {
        return (Integer)this.level().get() - 1;
    }

    default public boolean isVisible() {
        return false;
    }

    default public boolean shouldShowIcon() {
        return this.isVisible();
    }

    default public int getDuration(LivingEntity entity) {
        return (Integer)this.duration().get() * 20;
    }

    default public MobEffectInstance createEffect(LivingEntity entity) {
        return this.createEffect(this.getDuration(entity));
    }

    default public MobEffectInstance createEffect(int duration) {
        return new MobEffectInstance(this.mobEffect(), duration, this.getAmplifier(), false, this.isVisible(), this.shouldShowIcon());
    }

    @Override
    default public boolean isNonCosmetic() {
        return (Integer)this.level().get() > 0 && (Integer)this.duration().get() > 0;
    }
}

