/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.mobeffect;

import artifacts.ability.mobeffect.MobEffectAbility;
import artifacts.config.value.Value;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public abstract class ConstantMobEffectAbility
implements MobEffectAbility {
    private final Holder<MobEffect> mobEffect;
    protected final Value<Integer> level;

    protected ConstantMobEffectAbility(Holder<MobEffect> mobEffect) {
        this(mobEffect, Value.of(1));
    }

    protected ConstantMobEffectAbility(Holder<MobEffect> mobEffect, Value<Integer> level) {
        this.mobEffect = mobEffect;
        this.level = level;
    }

    @Override
    public Holder<MobEffect> mobEffect() {
        return this.mobEffect;
    }

    @Override
    public Value<Integer> level() {
        return this.level;
    }

    public boolean isInfinite() {
        return true;
    }

    @Override
    public int getDuration(LivingEntity entity) {
        return MobEffectAbility.super.getDuration(entity) + this.getAdditionalDuration(entity) + 19;
    }

    @Override
    public Value<Integer> duration() {
        return Value.of(1);
    }

    protected int getAdditionalDuration(LivingEntity target) {
        return 0;
    }

    @Nullable
    protected LivingEntity getTarget(LivingEntity entity) {
        return entity;
    }

    protected boolean shouldApplyMobEffect(LivingEntity entity) {
        return true;
    }

    @Override
    public void wornTick(LivingEntity entity, boolean isOnCooldown, boolean isActive) {
        LivingEntity target;
        if (!entity.level().isClientSide() && isActive && this.shouldApplyMobEffect(entity) && (target = this.getTarget(entity)) != null) {
            target.addEffect(this.createEffect(entity));
        }
    }

    @Override
    public void onUnequip(LivingEntity entity, boolean wasActive) {
        MobEffectInstance instance;
        if (!entity.level().isClientSide() && this.getTarget(entity) == entity && wasActive && (instance = entity.getEffect(this.mobEffect())) != null && instance.getAmplifier() == this.getAmplifier() && !instance.isVisible() && instance.endsWithin((Integer)this.duration().get() * 20 + 19)) {
            entity.removeEffect(this.mobEffect());
        }
    }
}

