/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModTags;
import artifacts.util.ModCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;

public record DamageImmunityAbility(Value<Boolean> enabled, TagKey<DamageType> tag) implements ArtifactAbility
{
    private static final Set<TagKey<DamageType>> CUSTOM_TOOLTIP_TAGS = Set.of(DamageTypeTags.IS_LIGHTNING, ModTags.IS_HOT_FLOOR);
    public static final MapCodec<DamageImmunityAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.enabledField().forGetter(DamageImmunityAbility::enabled), (App)TagKey.codec((ResourceKey)Registries.DAMAGE_TYPE).fieldOf("tag").forGetter(DamageImmunityAbility::tag)).apply((Applicative)instance, DamageImmunityAbility::new));
    public static final StreamCodec<ByteBuf, DamageImmunityAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.BOOLEAN.streamCodec(), DamageImmunityAbility::enabled, ModCodecs.tagKeyStreamCodec(Registries.DAMAGE_TYPE), DamageImmunityAbility::tag, DamageImmunityAbility::new);

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.DAMAGE_IMMUNITY.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return (Boolean)this.enabled().get();
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        if (CUSTOM_TOOLTIP_TAGS.contains(this.tag())) {
            tooltip.add(this.tooltipLine(this.tag().location().getPath(), new Object[0]));
        }
    }
}

