/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ArtifactsClient;
import artifacts.client.ToggleKeyHandler;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import artifacts.util.ModCodecs;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public interface ArtifactAbility {
    public static final Codec<ArtifactAbility> CODEC = ModCodecs.lazyCodec(() -> ModAbilities.getRegistry().byNameCodec().dispatch("type", ArtifactAbility::getType, Type::codec));
    public static final StreamCodec<RegistryFriendlyByteBuf, ArtifactAbility> STREAM_CODEC = ModCodecs.lazyStreamCodec(() -> ByteBufCodecs.registry((ResourceKey)ModAbilities.REGISTRY.key()).dispatch(ArtifactAbility::getType, Type::streamCodec));

    public Type<?> getType();

    public boolean isNonCosmetic();

    default public boolean isEnabled() {
        return this.isNonCosmetic();
    }

    default public boolean isActive(LivingEntity entity) {
        return this.isEnabled() && AbilityHelper.isToggledOn(this.getType(), entity);
    }

    default public void addTooltipIfNonCosmetic(List<MutableComponent> tooltip) {
        if (this.isNonCosmetic()) {
            this.addAbilityTooltip(tooltip);
            this.addToggleKeyTooltip(tooltip);
        }
    }

    default public void addAbilityTooltip(List<MutableComponent> tooltip) {
        ResourceLocation id = ModAbilities.REGISTRY.getId(this.getType());
        tooltip.add(Component.translatable((String)"%s.tooltip.ability.%s".formatted(id.getNamespace(), id.getPath())));
    }

    default public void addToggleKeyTooltip(List<MutableComponent> tooltip) {
        KeyMapping key = ToggleKeyHandler.getToggleKey(this.getType());
        Player player = null;
        if (Minecraft.getInstance() != null) {
            player = ArtifactsClient.getLocalPlayer();
        }
        if (!(key == null || player == null || key.isUnbound() && AbilityHelper.isToggledOn(this.getType(), (LivingEntity)player))) {
            tooltip.add(Component.translatable((String)"%s.tooltip.toggle_keymapping".formatted("artifacts"), (Object[])new Object[]{key.getTranslatedKeyMessage()}));
        }
    }

    default public MutableComponent tooltipLine(String abilityName, Object ... args) {
        ResourceLocation id = ModAbilities.REGISTRY.getId(this.getType());
        return Component.translatable((String)"%s.tooltip.ability.%s.%s".formatted(id.getNamespace(), id.getPath(), abilityName), (Object[])args);
    }

    default public void wornTick(LivingEntity entity, boolean isOnCooldown, boolean isActive) {
    }

    default public void onUnequip(LivingEntity entity, boolean wasActive) {
    }

    public record Type<T extends ArtifactAbility>(MapCodec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
    }
}

