/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.TooltiplessAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import artifacts.util.ModCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;

public record ApplyCooldownAfterDamageAbility(Value<Integer> cooldown, Optional<TagKey<DamageType>> tag) implements TooltiplessAbility
{
    public static final MapCodec<ApplyCooldownAfterDamageAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.DURATION.codec().fieldOf("cooldown").forGetter(ApplyCooldownAfterDamageAbility::cooldown), (App)TagKey.codec((ResourceKey)Registries.DAMAGE_TYPE).optionalFieldOf("tag").forGetter(ApplyCooldownAfterDamageAbility::tag)).apply((Applicative)instance, ApplyCooldownAfterDamageAbility::new));
    public static final StreamCodec<ByteBuf, ApplyCooldownAfterDamageAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.DURATION.streamCodec(), ApplyCooldownAfterDamageAbility::cooldown, (StreamCodec)ByteBufCodecs.optional(ModCodecs.tagKeyStreamCodec(Registries.DAMAGE_TYPE)), ApplyCooldownAfterDamageAbility::tag, ApplyCooldownAfterDamageAbility::new);

    public static void onLivingDamaged(LivingEntity entity, DamageSource damageSource) {
        AbilityHelper.applyCooldowns((ArtifactAbility.Type)ModAbilities.APPLY_COOLDOWN_AFTER_DAMAGE.value(), entity, ability -> {
            if (ability.tag().isEmpty() || damageSource.is(ability.tag().get())) {
                return (Integer)ability.cooldown().get();
            }
            return 0;
        });
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.APPLY_COOLDOWN_AFTER_DAMAGE.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return (Integer)this.cooldown.get() > 0;
    }
}

