/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.ct;

import com.simibubi.create.foundation.block.connected.AllCTTypes;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.CTType;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Couple;
import net.minecraft.resources.ResourceLocation;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.block.ModBlocks;

public final class ModSpriteShifts {
    public static final List<List<VibrantVaultSpriteShifts>> VIBRANT_VAULTS = ModSpriteShifts.getVibrantVaults();

    private ModSpriteShifts() {
    }

    public static VibrantVaultSpriteShifts ofVibrantVault(ModBlocks.VibrantVaultType type, ModBlocks.VibrantVaultColor color, boolean vertical) {
        return VIBRANT_VAULTS.get(type.ordinal() * 2 + (vertical ? 1 : 0)).get(color.ordinal());
    }

    private static Couple<CTSpriteShiftEntry> vibrantVault(String name, String shiftName, ModBlocks.VibrantVaultColor color) {
        String prefix = "block/" + name + "/" + color.asId() + "/vault_" + shiftName;
        return Couple.createWithContext(medium -> CTSpriteShifter.getCT((CTType)AllCTTypes.RECTANGLE, (ResourceLocation)CreateVibrantVaults.asResource(prefix + "_small"), (ResourceLocation)CreateVibrantVaults.asResource(medium != false ? prefix + "_medium" : prefix + "_large")));
    }

    private static List<List<VibrantVaultSpriteShifts>> getVibrantVaults() {
        ModBlocks.VibrantVaultType[] types = ModBlocks.VibrantVaultType.values();
        ArrayList<List<VibrantVaultSpriteShifts>> result = new ArrayList<List<VibrantVaultSpriteShifts>>(types.length * 2);
        for (ModBlocks.VibrantVaultType type : types) {
            boolean includeBaseColor = type != ModBlocks.VibrantVaultType.ITEM_VAULT;
            String horizontalTypeId = type.asId(false);
            String verticalTypeId = type.asId(true);
            ModBlocks.VibrantVaultColor[] colors = ModBlocks.VibrantVaultColor.values();
            ArrayList<VibrantVaultSpriteShifts> horizontalShifts = new ArrayList<VibrantVaultSpriteShifts>(includeBaseColor ? colors.length : colors.length - 1);
            ArrayList<VibrantVaultSpriteShifts> verticalShifts = new ArrayList<VibrantVaultSpriteShifts>(colors.length);
            for (ModBlocks.VibrantVaultColor color : ModBlocks.VibrantVaultColor.values()) {
                if (color != ModBlocks.VibrantVaultColor.BASE || includeBaseColor) {
                    horizontalShifts.add(color.ordinal(), new VibrantVaultSpriteShifts(horizontalTypeId, color, false));
                }
                verticalShifts.add(color.ordinal(), new VibrantVaultSpriteShifts(verticalTypeId, color, true));
            }
            result.add(type.ordinal() * 2, horizontalShifts);
            result.add(type.ordinal() * 2 + 1, verticalShifts);
        }
        return result;
    }

    public static void init() {
    }

    public static class VibrantVaultSpriteShifts {
        public final Couple<CTSpriteShiftEntry> top;
        public final Couple<CTSpriteShiftEntry> front;
        public final Couple<CTSpriteShiftEntry> side;
        public final Couple<CTSpriteShiftEntry> bottom;

        public VibrantVaultSpriteShifts(String name, ModBlocks.VibrantVaultColor color, boolean vertical) {
            this.top = ModSpriteShifts.vibrantVault(name, "top", color);
            this.front = vertical ? null : ModSpriteShifts.vibrantVault(name, "front", color);
            this.side = ModSpriteShifts.vibrantVault(name, "side", color);
            this.bottom = vertical ? null : ModSpriteShifts.vibrantVault(name, "bottom", color);
        }
    }
}

