/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class SuperGravityProcessor
extends StructureProcessor {
    public static final MapCodec<SuperGravityProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Heightmap.Types.CODEC.fieldOf("heightmap").orElse((Object)Heightmap.Types.WORLD_SURFACE_WG).forGetter(superGravityProcessor -> superGravityProcessor.heightmap), (App)Codec.INT.fieldOf("offset").orElse((Object)0).forGetter(superGravityProcessor -> superGravityProcessor.offset), (App)BuiltInRegistries.BLOCK.byNameCodec().listOf().fieldOf("ignore_block").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(superGravityProcessor -> superGravityProcessor.blocksToIgnore), (App)Codec.BOOL.fieldOf("require_water_surface").orElse((Object)false).forGetter(superGravityProcessor -> superGravityProcessor.requireWaterSurface)).apply((Applicative)instance, SuperGravityProcessor::new));
    private final Heightmap.Types heightmap;
    private final int offset;
    private final HashSet<Block> blocksToIgnore;
    private final boolean requireWaterSurface;

    public SuperGravityProcessor(Heightmap.Types types, int offset, HashSet<Block> blocksToIgnore, boolean requireWaterSurface) {
        this.heightmap = types;
        this.offset = offset;
        this.blocksToIgnore = blocksToIgnore;
        this.requireWaterSurface = requireWaterSurface;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings placeSettings) {
        Heightmap.Types heightmap$types = levelReader instanceof ServerLevel ? (this.heightmap == Heightmap.Types.WORLD_SURFACE_WG ? Heightmap.Types.WORLD_SURFACE : (this.heightmap == Heightmap.Types.OCEAN_FLOOR_WG ? Heightmap.Types.OCEAN_FLOOR : this.heightmap)) : this.heightmap;
        int heightmapY = levelReader.getHeight(heightmap$types, structureBlockInfoWorld.pos().getX(), structureBlockInfoWorld.pos().getZ());
        int localY = structureBlockInfoLocal.pos().getY();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.set(structureBlockInfoWorld.pos().getX(), heightmapY, structureBlockInfoWorld.pos().getZ());
        BlockState aboveState = levelReader.getBlockState((BlockPos)mutable);
        mutable.move(Direction.DOWN);
        BlockState currentState = levelReader.getBlockState((BlockPos)mutable);
        while (this.blocksToIgnore.contains(currentState.getBlock()) || this.requireWaterSurface && currentState.getFluidState().is(FluidTags.WATER)) {
            aboveState = currentState;
            mutable.move(Direction.DOWN);
            currentState = levelReader.getBlockState((BlockPos)mutable);
        }
        if (this.requireWaterSurface ? aboveState.getFluidState().is(FluidTags.WATER) : aboveState.isAir()) {
            return new StructureTemplate.StructureBlockInfo(new BlockPos(structureBlockInfoWorld.pos().getX(), mutable.getY() + localY + this.offset, structureBlockInfoWorld.pos().getZ()), structureBlockInfoWorld.state(), structureBlockInfoWorld.nbt());
        }
        return null;
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.SUPER_GRAVITY_PROCESSOR.get();
    }
}

