/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;

public class CloseOffFluidSourcesProcessor
extends StructureProcessor {
    public static final MapCodec<CloseOffFluidSourcesProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.mapPair((MapCodec)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block"), (MapCodec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight")).codec().listOf().fieldOf("weighted_list_of_replacement_blocks").forGetter(processor -> processor.weightedReplacementBlocks), (App)Codec.BOOL.fieldOf("ignore_down").orElse((Object)false).forGetter(processor -> processor.ignoreDown), (App)Codec.BOOL.fieldOf("if_air_in_world").orElse((Object)false).forGetter(processor -> processor.ifAirInWorld)).apply((Applicative)instance, instance.stable(CloseOffFluidSourcesProcessor::new)));
    private final List<Pair<Block, Integer>> weightedReplacementBlocks;
    private final boolean ignoreDown;
    private final boolean ifAirInWorld;

    public CloseOffFluidSourcesProcessor(List<Pair<Block, Integer>> weightedReplacementBlocks, boolean ignoreDown, boolean ifAirInWorld) {
        this.weightedReplacementBlocks = weightedReplacementBlocks;
        this.ignoreDown = ignoreDown;
        this.ifAirInWorld = ifAirInWorld;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings) {
        WorldGenRegion worldGenRegion;
        ChunkPos currentChunkPos = new ChunkPos(infoIn2.pos());
        if (infoIn2.state().is(Blocks.STRUCTURE_VOID) || !infoIn2.state().getFluidState().isEmpty()) {
            return infoIn2;
        }
        if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)currentChunkPos)) {
            return infoIn2;
        }
        if (!GeneralUtils.isFullCube((BlockGetter)levelReader, infoIn2.pos(), infoIn2.state()) || !infoIn2.state().blocksMotion()) {
            ChunkAccess currentChunk = levelReader.getChunk(currentChunkPos.x, currentChunkPos.z);
            if (this.ifAirInWorld && !currentChunk.getBlockState(infoIn2.pos()).isAir()) {
                return infoIn2;
            }
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                FluidState fluidState;
                int sectionYIndex;
                LevelChunkSection levelChunkSection;
                if (this.ignoreDown && direction == Direction.DOWN) continue;
                mutable.set((Vec3i)infoIn2.pos()).move(direction);
                if (mutable.getY() < currentChunk.getMinBuildHeight() || mutable.getY() >= currentChunk.getMaxBuildHeight()) continue;
                if (currentChunkPos.x != mutable.getX() >> 4 || currentChunkPos.z != mutable.getZ() >> 4) {
                    currentChunk = levelReader.getChunk((BlockPos)mutable);
                    currentChunkPos = new ChunkPos((BlockPos)mutable);
                }
                LevelHeightAccessor levelHeightAccessor = currentChunk.getHeightAccessorForGeneration();
                if (!(levelReader instanceof WorldGenLevel) || mutable.getY() < levelHeightAccessor.getMinBuildHeight() || mutable.getY() >= levelHeightAccessor.getMaxBuildHeight() || (levelChunkSection = currentChunk.getSection(sectionYIndex = currentChunk.getSectionIndex(mutable.getY()))) == null || !(fluidState = levelChunkSection.getFluidState(SectionPos.sectionRelative((int)mutable.getX()), SectionPos.sectionRelative((int)mutable.getY()), SectionPos.sectionRelative((int)mutable.getZ()))).isSource()) continue;
                RandomSource random = settings.getRandom(infoIn2.pos());
                Block replacementBlock = (Block)GeneralUtils.getRandomEntry(this.weightedReplacementBlocks, random);
                levelChunkSection.setBlockState(SectionPos.sectionRelative((int)mutable.getX()), SectionPos.sectionRelative((int)mutable.getY()), SectionPos.sectionRelative((int)mutable.getZ()), replacementBlock.defaultBlockState(), false);
            }
        }
        return infoIn2;
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.CLOSE_OFF_FLUID_SOURCES_PROCESSOR.get();
    }
}

