/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureTargetAndLengthConfig;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StructureVineBreakage
extends Feature<StructureTargetAndLengthConfig> {
    private static final Predicate<BlockState> FORTRESS_BLOCKS = blockState -> {
        if (blockState == null) {
            return false;
        }
        return blockState.is(BlockTags.BASE_STONE_OVERWORLD) || blockState.is(BlockTags.STONE_BRICKS) || blockState.is(BlockTags.DIRT) | blockState.is(Blocks.INFESTED_CHISELED_STONE_BRICKS) || blockState.is(Blocks.INFESTED_CRACKED_STONE_BRICKS) || blockState.is(Blocks.INFESTED_STONE_BRICKS) || blockState.is(Blocks.INFESTED_MOSSY_STONE_BRICKS) || blockState.is(Blocks.IRON_BARS);
    };

    public StructureVineBreakage(Codec<StructureTargetAndLengthConfig> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<StructureTargetAndLengthConfig> context) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < ((StructureTargetAndLengthConfig)context.config()).attempts; ++i) {
            mutable.set((Vec3i)context.origin()).move(context.random().nextInt(7) - 3, context.random().nextInt(5) - 1, context.random().nextInt(7) - 3);
            if (!FORTRESS_BLOCKS.test(context.level().getBlockState((BlockPos)mutable)) || !context.level().isEmptyBlock(mutable.below())) continue;
            context.level().setBlock((BlockPos)mutable, Blocks.CAVE_AIR.defaultBlockState(), 3);
            BlockPos.MutableBlockPos vineMutablePos = new BlockPos.MutableBlockPos().set((Vec3i)mutable);
            BlockState neighboringBlock = context.level().getBlockState((BlockPos)vineMutablePos);
            WorldGenLevel level = context.level();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                vineMutablePos.set((Vec3i)mutable).move(direction);
                while (mutable.getY() > level.getMinBuildHeight() && mutable.getY() < level.getMaxBuildHeight() && (neighboringBlock.is(BlockTags.REPLACEABLE_BY_TREES) || neighboringBlock.is(BlockTags.FLOWERS))) {
                    level.setBlock((BlockPos)vineMutablePos, Blocks.CAVE_AIR.defaultBlockState(), 3);
                    neighboringBlock = level.getBlockState((BlockPos)vineMutablePos.move(Direction.DOWN));
                }
            }
            BlockPos.MutableBlockPos replacingPlantMutable = new BlockPos.MutableBlockPos().set((Vec3i)mutable);
            BlockState plantState = context.level().getBlockState((BlockPos)replacingPlantMutable.move(Direction.UP));
            while (mutable.getY() > level.getMinBuildHeight() && mutable.getY() < level.getMaxBuildHeight() && (plantState.is(BlockTags.REPLACEABLE_BY_TREES) || plantState.is(BlockTags.FLOWERS))) {
                context.level().setBlock((BlockPos)replacingPlantMutable, Blocks.AIR.defaultBlockState(), 3);
                plantState = context.level().getBlockState((BlockPos)replacingPlantMutable.move(Direction.UP));
            }
            vineMutablePos.set((Vec3i)mutable);
            ChunkPos currentChunkPos = new ChunkPos((BlockPos)vineMutablePos);
            int maxLength = ((StructureTargetAndLengthConfig)context.config()).length - context.random().nextInt(context.random().nextInt(((StructureTargetAndLengthConfig)context.config()).length) + 1);
            int targetY = vineMutablePos.getY() - maxLength;
            while (vineMutablePos.getY() >= targetY && context.level().isEmptyBlock((BlockPos)vineMutablePos)) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    mutable.set((Vec3i)vineMutablePos).move(direction);
                    ChunkPos newChunkPos = new ChunkPos((BlockPos)mutable);
                    if (newChunkPos.x != currentChunkPos.x || newChunkPos.z != currentChunkPos.z) continue;
                    BlockState currentBlockstate = (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.getPropertyForFace((Direction)direction), (Comparable)Boolean.TRUE);
                    BlockState aboveBlockstate = context.level().getBlockState(vineMutablePos.above());
                    if (currentBlockstate.canSurvive((LevelReader)context.level(), (BlockPos)vineMutablePos) && context.level().getBlockState(vineMutablePos.relative(direction)).getBlock() != Blocks.MOSS_CARPET) {
                        context.level().setBlock((BlockPos)vineMutablePos, (BlockState)currentBlockstate.setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(aboveBlockstate.canOcclude())), 2);
                        break;
                    }
                    if (!aboveBlockstate.is(Blocks.VINE)) continue;
                    context.level().setBlock((BlockPos)vineMutablePos, (BlockState)aboveBlockstate.setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(false)), 2);
                    break;
                }
                vineMutablePos.move(Direction.DOWN);
            }
        }
        return true;
    }
}

