/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.lootmanager;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.configs.RSMainModdedLootConfig;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.PlatformHooks;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;

public class StructureModdedLootImporter {
    public static final Map<ResourceLocation, ResourceLocation> TABLE_IMPORTS = StructureModdedLootImporter.createMap();
    private static Set<ResourceLocation> BLACKLISTED_LOOTTABLES;

    public static Map<ResourceLocation, ResourceLocation> createMap() {
        Object2ObjectOpenHashMap tableMap = new Object2ObjectOpenHashMap();
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/cities/nether"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/bastion_treasure"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/cities/overworld"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_plains_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ancient_cities/ocean"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ancient_city"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ancient_cities/ocean_ice_box"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ancient_city_ice_box"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ancient_cities/nether"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ancient_city"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ancient_cities/nether_magma_box"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ancient_city_ice_box"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ancient_cities/end"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ancient_city"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ancient_cities/end_spawner_box"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ancient_city_ice_box"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/bastions/underground/treasure"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_crossing"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/bastions/underground/bridge"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_corridor"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/bastions/underground/other"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_corridor"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/bastions/underground/skeleton_horse_stable"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_corridor"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/dungeons/badlands"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/simple_dungeon"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/dungeons/dark_forest"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/simple_dungeon"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/dungeons/deep"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/simple_dungeon"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/dungeons/desert"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/simple_dungeon"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/dungeons/icy"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/simple_dungeon"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/dungeons/jungle"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/simple_dungeon"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/dungeons/mushroom"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/simple_dungeon"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/dungeons/nether"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/simple_dungeon"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/dungeons/ocean"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/simple_dungeon"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/dungeons/snow"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/simple_dungeon"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/dungeons/swamp"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/simple_dungeon"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"shulker_boxes/dungeons/end"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/simple_dungeon"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/fortresses/jungle_center"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_crossing"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/fortresses/jungle_hallway"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_corridor"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/fortresses/jungle_shrine"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_crossing"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/igloos/grassy"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/igloo_chest"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/igloos/stone"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/igloo_chest"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/igloos/mangrove"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/igloo_chest"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/igloos/mushroom"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/igloo_chest"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mansions/birch"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/woodland_mansion"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mansions/desert"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/woodland_mansion"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mansions/jungle"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/woodland_mansion"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mansions/mangrove"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/woodland_mansion"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mansions/oak"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/woodland_mansion"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mansions/savanna"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/woodland_mansion"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mansions/snowy"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/woodland_mansion"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mansions/taiga"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/woodland_mansion"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/basalt"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/birch"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/crimson"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/dark_forest"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/desert"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/end"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/icy"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/jungle"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/nether"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/ocean"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/savanna"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/soul"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/stone"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/swamp"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/taiga"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/mineshafts/warped"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/abandoned_mineshaft"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/basalt"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/badlands"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/birch"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/crimson"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/desert"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/giant_tree_taiga"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/icy"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/jungle"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/mangrove"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/nether_brick"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/oak"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/ocean"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/savanna"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/soul"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/snowy"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/taiga"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/outposts/warped"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"shulker_boxes/outposts/end"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/pyramids/dark_forest"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/pyramids/end"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/pyramids/flower_forest"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/pyramids/giant_tree_taiga"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/pyramids/icy"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/pyramids/jungle"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/pyramids/mushroom"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/pyramids/snowy"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"trapped_chests/pyramids/badlands"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"trapped_chests/pyramids/end"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"trapped_chests/pyramids/nether"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"trapped_chests/pyramids/ocean"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"dispensers/pyramids/dark_forest"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ruined_portals/end/large_portal"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ruined_portal"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ruined_portals/end/small_portal"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ruined_portal"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ruins/land_hot/large"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_desert_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ruins/land_hot/small"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_desert_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ruins/land_warm/large"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_plains_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ruins/land_warm/small"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_plains_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ruins/land_cold/large"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_taiga_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ruins/land_cold/small"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_taiga_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ruins/land_icy/large"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_snowy_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ruins/land_icy/small"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_snowy_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/ruins/nether"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/bastion_other"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/shipwrecks/crimson/map"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/shipwreck_map"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/shipwrecks/crimson/supply"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/shipwreck_supply"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/shipwrecks/crimson/treasure"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/shipwreck_treasure"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/shipwrecks/end/map"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/shipwreck_map"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/shipwrecks/end/supply"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/shipwreck_supply"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/shipwrecks/end/treasure"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/shipwrecks/warped/map"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/shipwreck_map"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/shipwrecks/warped/supply"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/shipwreck_supply"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/shipwrecks/warped/treasure"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/shipwreck_treasure"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/shipwrecks/nether_bricks/treasure"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/shipwreck_treasure"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"shulker_boxes/strongholds/end_storage_room"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"shulker_boxes/strongholds/end_hallway"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"shulker_boxes/strongholds/end_library"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/strongholds/nether_storage_room"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_crossing"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/strongholds/nether_hallway"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_corridor"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/strongholds/nether_library"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_library"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/temples/basalt"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/nether_bridge"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/temples/crimson"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/nether_bridge"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/temples/soul"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/nether_bridge"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/temples/warped"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/nether_bridge"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/temples/wasteland"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/nether_bridge"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/temples/taiga"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/jungle_temple"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/temples/ocean"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/jungle_temple"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"trapped_chests/temples/warped"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/nether_bridge"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"dispensers/temples/basalt"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/jungle_temple_dispenser"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"dispensers/temples/crimson"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/jungle_temple_dispenser"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"dispensers/temples/soul"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/jungle_temple_dispenser"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"dispensers/temples/warped"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/jungle_temple_dispenser"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"dispensers/temples/wasteland"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/jungle_temple_dispenser"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"dispensers/temples/taiga"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/jungle_temple_dispenser"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/badlands_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_desert_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/bamboo_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_savanna_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/birch_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_plains_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/cherry_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_plains_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/dark_forest_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_plains_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/giant_taiga_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_taiga_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/jungle_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_savanna_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/mountains_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_snowy_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/mushroom_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_plains_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/oak_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_plains_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/ocean_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_plains_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/ocean_cartographer"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_cartographer"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/swamp_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_plains_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/crimson_cartographer"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_cartographer"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/crimson_fisher"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_fisher"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/crimson_tannery"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_tannery"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/crimson_weaponsmith"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_weaponsmith"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/crimson_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_desert_house"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/warped_cartographer"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_cartographer"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/warped_fisher"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_fisher"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/warped_tannery"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_tannery"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/warped_weaponsmith"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_weaponsmith"));
        tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"repurposed_structures", (String)"chests/villages/warped_house"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/village/village_desert_house"));
        if (PlatformHooks.isModLoaded("betterstrongholds")) {
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/end/armoury"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/end/common"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/end/crypt"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/end/grand_library"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/end/library_md"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/end/mess"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/end/prison_lg"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/end/trap"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/end/treasure"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/nether/common"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_crossing"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/nether/mess"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_crossing"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/nether/armoury"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_corridor"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/nether/crypt"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_corridor"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/nether/prison_lg"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_corridor"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/nether/trap"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_corridor"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/nether/treasure"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_corridor"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/nether/grand_library"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_library"));
            tableMap.put(ResourceLocation.fromNamespaceAndPath((String)"betterstrongholds", (String)"chests/nether/library_md"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/stronghold_library"));
        }
        return tableMap;
    }

    public static boolean isInBlacklist(ResourceLocation lootTableID) {
        if (BLACKLISTED_LOOTTABLES == null) {
            String cleanedBlacklist = RSMainModdedLootConfig.blacklistedRSLoottablesFromImportingModdedItems.trim();
            BLACKLISTED_LOOTTABLES = cleanedBlacklist.isEmpty() ? new HashSet<ResourceLocation>() : Arrays.stream(cleanedBlacklist.split(",")).map(String::trim).map(ResourceLocation::tryParse).collect(Collectors.toSet());
        }
        return BLACKLISTED_LOOTTABLES.contains(lootTableID);
    }

    public static void checkLoottables(MinecraftServer minecraftServer) {
        boolean invalidLootTableFound = false;
        for (Map.Entry<ResourceLocation, ResourceLocation> entry : TABLE_IMPORTS.entrySet()) {
            if (entry.getKey().getNamespace().equals("betterstrongholds") || !GeneralUtils.isInvalidLootTableFound(minecraftServer, entry)) continue;
            invalidLootTableFound = true;
        }
        if (GeneralUtils.isMissingLootImporting(minecraftServer, TABLE_IMPORTS.keySet())) {
            invalidLootTableFound = true;
        }
        if (invalidLootTableFound) {
            RepurposedStructures.LOGGER.error("Unknown import/target loot tables found for Repurposed Structures. See above logs and report to TelepathicGrunt please.");
        }
    }
}

