/*
 * Decompiled with CFR 0.152.
 */
package com.biomemusic.mixin;

import com.biomemusic.AdditionalMusic;
import com.biomemusic.BiomeMusic;
import com.biomemusic.config.CommonConfiguration;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ResourceLoadStateTracker;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ResourceLoadStateTracker.class})
public class ReloadHookMixin {
    @Inject(method={"finishReload"}, at={@At(value="RETURN")})
    private void checkExistance(CallbackInfo ci) {
        List<Music> toTest = List.of(AdditionalMusic.CAVE_ADDITIONAL, AdditionalMusic.END_ADDITIONAL, AdditionalMusic.NIGHT_ADDITIONAL, AdditionalMusic.GAME_ADDITIONAL, AdditionalMusic.WATER_ADDITIONAL, AdditionalMusic.MENU_ADDITIONAL);
        AdditionalMusic.DISABLED.clear();
        for (Music music : toTest) {
            SimpleSoundInstance soundInstance = SimpleSoundInstance.forMusic((SoundEvent)((SoundEvent)music.getEvent().value()));
            WeighedSoundEvents sound = soundInstance.resolve(Minecraft.getInstance().getSoundManager());
            if (sound != null && soundInstance.getSound() != SoundManager.EMPTY_SOUND) continue;
            if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).logloadedmusic) {
                BiomeMusic.LOGGER.info("Disabled music event due to being empty:" + String.valueOf(((SoundEvent)music.getEvent().value()).getLocation()));
            }
            AdditionalMusic.DISABLED.add(music);
        }
    }
}

