/*
 * Decompiled with CFR 0.152.
 */
package com.biomemusic.mixin;

import com.biomemusic.AdditionalMusic;
import com.biomemusic.BiomeMusic;
import com.biomemusic.config.CommonConfiguration;
import com.biomemusic.environment.MusicEnvironment;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundEngine.class})
public class MusicPlayMixin {
    @Shadow
    @Final
    private Map<SoundInstance, Integer> soundDeleteTime;
    @Unique
    private static final Map<ResourceLocation, ResourceLocation> oncePlayed = new HashMap<ResourceLocation, ResourceLocation>();

    @Inject(method={"play"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/sounds/SoundInstance;getSound()Lnet/minecraft/client/resources/sounds/Sound;")})
    private void biomesMusic$onPlay(SoundInstance sound, CallbackInfo ci) {
        if (sound.getSource() != SoundSource.MUSIC) {
            return;
        }
        if (sound instanceof AbstractSoundInstance && ((CommonConfiguration)BiomeMusic.config.getCommonConfig()).pitchVariance > 0.0f) {
            ((AbstractSoundInstance)sound).pitch += BiomeMusic.rand.nextFloat(((CommonConfiguration)BiomeMusic.config.getCommonConfig()).pitchVariance * 2.0f) - ((CommonConfiguration)BiomeMusic.config.getCommonConfig()).pitchVariance;
        }
        if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).displayMusicPlayed) {
            BiomeMusic.LOGGER.info("playing: " + String.valueOf(sound.getLocation()) + " sound:" + String.valueOf(sound.getSound().getLocation()) + " environment: " + String.valueOf(MusicEnvironment.environment));
            if (Minecraft.getInstance().player != null) {
                Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("playing: " + String.valueOf(sound.getSound().getLocation()))), true);
            }
        }
        if (sound.getSound() == SoundManager.EMPTY_SOUND && sound.getLocation().getNamespace().equals("biomemusic")) {
            Minecraft.getInstance().getMusicManager().nextSongDelay = 0;
        }
    }

    @Inject(method={"play"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/sounds/SoundInstance;getVolume()F")}, cancellable=true)
    private void biomesMusic$onPlaySound(SoundInstance sound, CallbackInfo ci) {
        if (sound.getSound() == null || Minecraft.getInstance().player == null) {
            return;
        }
        if (!sound.isRelative() && sound.getAttenuation() != SoundInstance.Attenuation.NONE) {
            if (!oncePlayed.containsKey(sound.getLocation())) {
                oncePlayed.put(sound.getLocation(), sound.getLocation());
                return;
            }
            if (AdditionalMusic.stereoIDs.containsKey(sound.getLocation())) {
                return;
            }
            if (sound.getX() == 0.0 && sound.getY() == 0.0 && sound.getZ() == 0.0) {
                return;
            }
            double distance = Minecraft.getInstance().player.position().distanceTo(new Vec3(sound.getX(), sound.getY(), sound.getZ()));
            if (distance > Math.max(1.0, (double)sound.getVolume()) * (double)sound.getSound().getAttenuationDistance() + 10.0) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"play"}, at={@At(value="HEAD")}, cancellable=true)
    private void biomesMusic$limitMaxConcurrent(SoundInstance soundInstance, CallbackInfo ci) {
        if (this.soundDeleteTime == null || soundInstance == null) {
            return;
        }
        int similarcount = 0;
        for (SoundInstance sound : this.soundDeleteTime.keySet()) {
            if (!sound.getLocation().equals((Object)soundInstance.getLocation()) || ++similarcount != ((CommonConfiguration)BiomeMusic.config.getCommonConfig()).maxConcurrentSounds) continue;
            ci.cancel();
            break;
        }
    }
}

