/*
 * Decompiled with CFR 0.152.
 */
package com.biomemusic.mixin;

import com.biomemusic.AdditionalMusic;
import com.biomemusic.BiomeMusic;
import com.biomemusic.config.CommonConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicManager.class}, priority=5)
public abstract class MusicManagerMixin {
    @Unique
    private Music playedMusic = null;
    @Unique
    private long startTime = 0L;
    private long lastBiomeTime = 0L;
    @Unique
    float fadeTowards = -1.0f;
    @Unique
    float modifiedVolume = 1.0f;

    @Shadow
    public abstract void stopPlaying();

    @Inject(method={"startPlaying"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundManager;play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V")})
    private void onStartMusic(Music music, CallbackInfo ci) {
        this.playedMusic = music;
        if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).smartMusic && this.playedMusic != null && Minecraft.getInstance().level != null && Minecraft.getInstance().player != null) {
            this.startTime = Minecraft.getInstance().level.getGameTime();
            Biome biome = (Biome)Minecraft.getInstance().level.getBiome(Minecraft.getInstance().player.blockPosition()).value();
            this.lastBiomeTime = biome.getBackgroundMusic().isPresent() && ((Music)biome.getBackgroundMusic().get()).equals(this.playedMusic) ? this.startTime : 0L;
            this.fadeIn();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).smartMusic && this.playedMusic != null && this.fadeTowards != -1.0f && Minecraft.getInstance().level != null && Minecraft.getInstance().player != null && Minecraft.getInstance().level.getGameTime() - this.startTime > 300L) {
            this.modifiedVolume += (float)(this.fadeTowards > 0.1f ? 1 : -1) * (Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.MUSIC) / 400.0f);
            this.modifiedVolume = Math.min(Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.MUSIC), this.modifiedVolume);
            Minecraft.getInstance().getSoundManager().updateSourceVolume(SoundSource.MUSIC, this.modifiedVolume);
            if ((double)Math.abs(this.modifiedVolume - this.fadeTowards) < 0.01) {
                if (this.fadeTowards == 0.1f) {
                    this.playedMusic = null;
                    this.stopPlaying();
                }
                this.fadeTowards = -1.0f;
                Minecraft.getInstance().getSoundManager().updateSourceVolume(SoundSource.MUSIC, Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.MUSIC));
            }
        }
        if (this.playedMusic != null && BiomeMusic.rand.nextInt(20) == 0 && Minecraft.getInstance().level != null && Minecraft.getInstance().player != null) {
            ClientLevel level = Minecraft.getInstance().level;
            LocalPlayer player = Minecraft.getInstance().player;
            if (this.playedMusic == AdditionalMusic.NIGHT_ADDITIONAL && Minecraft.getInstance().level.getDayTime() < 12000L) {
                if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).displayMusicPlayed) {
                    BiomeMusic.LOGGER.info("Fading out music: " + String.valueOf(this.playedMusic) + " due to daytime");
                }
                this.fadeOut();
                return;
            }
            if (this.playedMusic == AdditionalMusic.CAVE_ADDITIONAL && AdditionalMusic.CAVE_TICKS < 30) {
                if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).displayMusicPlayed) {
                    BiomeMusic.LOGGER.info("Fading out music: " + String.valueOf(this.playedMusic) + " due to leaving cave");
                }
                this.fadeOut();
                return;
            }
            if (!(this.playedMusic != AdditionalMusic.WATER_ADDITIONAL && this.playedMusic != Musics.UNDER_WATER || Minecraft.getInstance().player == null || Minecraft.getInstance().player.isUnderWater())) {
                if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).displayMusicPlayed) {
                    BiomeMusic.LOGGER.info("Fading out music: " + String.valueOf(this.playedMusic) + " due to leaving water");
                }
                this.fadeOut();
                return;
            }
            if ((this.playedMusic == AdditionalMusic.END_ADDITIONAL || this.playedMusic == Musics.END || this.playedMusic == Musics.END_BOSS) && Minecraft.getInstance().player != null && Minecraft.getInstance().player.level().dimension() != Level.END) {
                if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).displayMusicPlayed) {
                    BiomeMusic.LOGGER.info("Fading out music: " + String.valueOf(this.playedMusic) + " due to leaving the end");
                }
                this.fadeOut();
                return;
            }
            if (this.playedMusic == AdditionalMusic.NETHER_ALL && Minecraft.getInstance().player != null && Minecraft.getInstance().player.level().dimension() != Level.NETHER) {
                if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).displayMusicPlayed) {
                    BiomeMusic.LOGGER.info("Fading out music: " + String.valueOf(this.playedMusic) + " due to leaving the nether");
                }
                this.fadeOut();
                return;
            }
            if (this.lastBiomeTime > 0L) {
                Biome biome = (Biome)level.getBiome(player.blockPosition()).value();
                if (biome.getBackgroundMusic().isPresent()) {
                    if (((Music)biome.getBackgroundMusic().get()).equals(this.playedMusic)) {
                        this.lastBiomeTime = level.getGameTime();
                    } else if (level.getGameTime() - this.lastBiomeTime > 600L) {
                        if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).displayMusicPlayed) {
                            BiomeMusic.LOGGER.info("Fading out music: " + String.valueOf(this.playedMusic) + " due to changing biomes");
                        }
                        this.fadeOut();
                    }
                }
                return;
            }
        }
    }

    @Unique
    private void fadeOut() {
        if (this.fadeTowards != 0.1f) {
            this.modifiedVolume = Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.MUSIC);
            this.fadeTowards = 0.1f;
        }
    }

    @Unique
    private void fadeIn() {
        if (this.fadeTowards != Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.MUSIC)) {
            this.fadeTowards = Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.MUSIC);
            this.modifiedVolume = 0.1f;
            Minecraft.getInstance().getSoundManager().updateSourceVolume(SoundSource.MUSIC, this.modifiedVolume);
        }
    }
}

