/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.flightblocks.event;

import com.benbenlaw.flightblocks.block.entity.FlightBlockEntity;
import com.benbenlaw.flightblocks.config.StartupConfig;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="flightblocks")
public class FlightBlockEventHandler {
    private static final Set<ServerPlayer> playersWithFlightEnabled = new HashSet<ServerPlayer>();
    private static final int RANGE = (Integer)StartupConfig.flightBlockRange.get();

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide()) {
            ServerLevel level = (ServerLevel)player.level();
            if (FlightBlockEventHandler.isPlayerNearFlightBlock(player, level)) {
                FlightBlockEventHandler.enableFlight(player);
            } else {
                FlightBlockEventHandler.disableFlight(player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Level newLevel = player.level();
        if (!newLevel.isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)newLevel;
            if (FlightBlockEventHandler.isPlayerNearFlightBlock((Player)player, serverLevel)) {
                FlightBlockEventHandler.enableFlight((Player)player);
            } else {
                FlightBlockEventHandler.disableFlight((Player)player);
            }
        }
    }

    private static boolean isPlayerNearFlightBlock(Player player, ServerLevel level) {
        for (FlightBlockEntity blockEntity : FlightBlockEntity.ACTIVE_BLOCKS) {
            AABB range;
            if (blockEntity.getLevel() != level || !(range = new AABB(blockEntity.getBlockPos()).inflate((double)RANGE)).contains(player.position())) continue;
            return true;
        }
        return false;
    }

    private static void enableFlight(Player player) {
        if (!(player.isCreative() || player.isSpectator() || player.getAbilities().mayfly)) {
            player.addTag("flight_blocks_flight");
            player.getAbilities().mayfly = true;
            player.onUpdateAbilities();
            player.sendSystemMessage((Component)Component.translatable((String)"block.flightblocks.flight_block.enabled_flight").withStyle(ChatFormatting.GREEN));
            playersWithFlightEnabled.add((ServerPlayer)player);
        }
    }

    private static void disableFlight(Player player) {
        if (!player.isCreative() && !player.isSpectator() && player.getAbilities().mayfly && player.getTags().contains("flight_blocks_flight")) {
            player.removeTag("flight_blocks_flight");
            player.getAbilities().mayfly = false;
            player.onUpdateAbilities();
            player.sendSystemMessage((Component)Component.translatable((String)"block.flightblocks.flight_block.disabled_flight").withStyle(ChatFormatting.RED));
            playersWithFlightEnabled.remove(player);
        }
    }
}

