/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.flightblocks.block.entity;

import com.benbenlaw.flightblocks.block.entity.FlightBlockEntities;
import com.benbenlaw.flightblocks.config.StartupConfig;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class FlightBlockEntity
extends BlockEntity {
    public static final int RANGE = (Integer)StartupConfig.flightBlockRange.get();
    private final Set<ServerPlayer> enabledPlayers = new HashSet<ServerPlayer>();
    public static final Set<FlightBlockEntity> ACTIVE_BLOCKS = new HashSet<FlightBlockEntity>();

    public FlightBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FlightBlockEntities.FLIGHT_BLOCK_ENTITY.get(), pos, state);
        ACTIVE_BLOCKS.add(this);
    }

    public void tick() {
    }

    public void setRemoved() {
        super.setRemoved();
        ACTIVE_BLOCKS.remove((Object)this);
    }

    public InteractionResult onRightClick(ServerPlayer player) {
        Level level = this.getLevel();
        if (level != null && !level.isClientSide()) {
            this.showFlightRange((ServerLevel)level, player);
            player.sendSystemMessage((Component)Component.translatable((String)"block.flightblocks.flight_block.range").append(String.valueOf(RANGE)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void showFlightRange(ServerLevel level, ServerPlayer player) {
        AABB range = new AABB(this.worldPosition).inflate((double)RANGE, (double)RANGE, (double)RANGE);
        double minX = range.minX;
        double minY = range.minY;
        double minZ = range.minZ;
        double maxX = range.maxX;
        double maxY = range.maxY;
        double maxZ = range.maxZ;
        for (double x = minX; x < maxX; x += 1.0) {
            for (double y = minY; y < maxY; y += 1.0) {
                for (double z = minZ; z < maxZ; z += 1.0) {
                    if (x != minX && x != maxX - 1.0 && y != minY && y != maxY - 1.0 && z != minZ && z != maxZ - 1.0) continue;
                    level.sendParticles(player, (ParticleOptions)ParticleTypes.END_ROD, true, x + 0.5, y + 0.5, z + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

