/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.inventory;

import com.mrcrayfish.goldenhopper.core.ModContainers;
import com.mrcrayfish.goldenhopper.inventory.slot.FilterSlot;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GoldenHopperMenu
extends AbstractContainerMenu {
    private final Container container;

    public GoldenHopperMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, (Container)new SimpleContainer(6));
    }

    public GoldenHopperMenu(int windowId, Inventory playerInventory, Container container) {
        super((MenuType)ModContainers.GOLDEN_HOPPER.get(), windowId);
        int i;
        this.container = container;
        GoldenHopperMenu.checkContainerSize((Container)container, (int)6);
        container.startOpen(playerInventory.player);
        this.addSlot(new FilterSlot(container, 0, 26, 20));
        for (i = 0; i < 5; ++i) {
            this.addSlot(new Slot(container, i + 1, 62 + i * 18, 20));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, i * 18 + 51));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 109));
        }
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            result = slotStack.copy();
            if (index < this.container.getContainerSize() ? !this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(slotStack, 1, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return result;
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }
}

