/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.entity.vehicle;

import com.mrcrayfish.goldenhopper.core.ModBlocks;
import com.mrcrayfish.goldenhopper.core.ModEntities;
import com.mrcrayfish.goldenhopper.core.ModItems;
import com.mrcrayfish.goldenhopper.inventory.GoldenHopperMenu;
import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class GoldenHopperMinecart
extends MinecartHopper
implements WorldlyContainer {
    private static final int CONTAINER_SIZE = 6;
    private static final int FILTER_SLOT_INDEX = 0;

    public GoldenHopperMinecart(EntityType<? extends GoldenHopperMinecart> type, Level level) {
        super(type, level);
    }

    public GoldenHopperMinecart(Level level, double x, double y, double z) {
        super((EntityType)ModEntities.GOLDEN_HOPPER_MINECART.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public int getContainerSize() {
        return 6;
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return new GoldenHopperMenu(windowId, playerInventory, (Container)this);
    }

    public BlockState getDefaultDisplayBlockState() {
        return ((Block)ModBlocks.GOLDEN_HOPPER.get()).defaultBlockState();
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)ModItems.GOLDEN_HOPPER_MINECART.get());
    }

    protected Item getDropItem() {
        return (Item)ModItems.GOLDEN_HOPPER_MINECART.get();
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index != 0 && (this.getItem(0).isEmpty() || stack.getItem() == this.getItem(0).getItem());
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).filter(value -> value != 0).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return index != 0 && (this.getItem(0).isEmpty() || stack.getItem() == this.getItem(0).getItem());
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index != 0;
    }

    public boolean canTakeItem(Container container, int index, ItemStack stack) {
        return index != 0;
    }

    public int getComparatorLevel() {
        float filled = IntStream.range(1, this.getContainerSize()).mapToObj(arg_0 -> ((GoldenHopperMinecart)this).getItem(arg_0)).filter(stack -> !stack.isEmpty()).map(stack -> Float.valueOf((float)stack.getCount() / (float)Math.min(this.getMaxStackSize(), stack.getMaxStackSize()))).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
        return Mth.floor((float)((filled /= (float)this.getContainerSize() - 1.0f) * 14.0f)) + (filled > 0.0f ? 1 : 0);
    }
}

