/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.data;

import com.mrcrayfish.goldenhopper.data.NeoForgeBlockTagGen;
import com.mrcrayfish.goldenhopper.data.NeoForgeItemTagGen;
import com.mrcrayfish.goldenhopper.data.NeoForgeLootTableGen;
import com.mrcrayfish.goldenhopper.data.NeoForgeRecipeGen;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="goldenhopper", bus=EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    private static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new NeoForgeRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NeoForgeLootTableGen(output, lookupProvider));
        NeoForgeBlockTagGen blockTagGen = new NeoForgeBlockTagGen(output, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTagGen);
        generator.addProvider(event.includeServer(), (DataProvider)new NeoForgeItemTagGen(output, lookupProvider, blockTagGen.contentsGetter(), event.getExistingFileHelper()));
    }
}

