/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.blockentity;

import com.mrcrayfish.goldenhopper.blockentity.BlockEntityTypeSetter;
import com.mrcrayfish.goldenhopper.core.ModBlockEntities;
import com.mrcrayfish.goldenhopper.inventory.GoldenHopperMenu;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class GoldenHopperBlockEntity
extends HopperBlockEntity
implements WorldlyContainer {
    public static final int CONTAINER_SIZE = 6;
    public static final int FILTER_SLOT_INDEX = 0;
    public static final int[] TRANSFERABLE_SLOTS = IntStream.range(1, 6).toArray();
    public static boolean ejecting = false;

    public GoldenHopperBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
        this.setItems(NonNullList.withSize((int)6, (Object)ItemStack.EMPTY));
        ((BlockEntityTypeSetter)((Object)this)).goldenHopper$SetType((BlockEntityType)ModBlockEntities.GOLDEN_HOPPER.get());
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModBlockEntities.GOLDEN_HOPPER.get();
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.goldenhopper.golden_hopper");
    }

    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return new GoldenHopperMenu(windowId, playerInventory, (Container)this);
    }

    public ItemStack getItem(int slot) {
        if (ejecting && slot == 0) {
            return ItemStack.EMPTY;
        }
        return super.getItem(slot);
    }

    public int[] getSlotsForFace(Direction side) {
        return TRANSFERABLE_SLOTS;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index != 0 && (((ItemStack)this.getItems().get(0)).isEmpty() || stack.getItem() == ((ItemStack)this.getItems().get(0)).getItem());
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return ((ItemStack)this.getItems().get(0)).isEmpty() || stack.getItem() == ((ItemStack)this.getItems().get(0)).getItem();
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index != 0;
    }

    public boolean canTakeItem(Container container, int index, ItemStack stack) {
        return index != 0;
    }
}

