/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.block;

import com.mojang.serialization.MapCodec;
import com.mrcrayfish.goldenhopper.blockentity.GoldenHopperBlockEntity;
import com.mrcrayfish.goldenhopper.core.ModBlockEntities;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class GoldenHopperBlock
extends HopperBlock {
    public static final MapCodec<HopperBlock> CODEC = GoldenHopperBlock.simpleCodec(GoldenHopperBlock::new);

    public GoldenHopperBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<HopperBlock> codec() {
        return CODEC;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (!level.isClientSide()) {
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity instanceof GoldenHopperBlockEntity) {
                GoldenHopperBlockEntity hopper = (GoldenHopperBlockEntity)entity;
                player.openMenu((MenuProvider)hopper);
                player.awardStat(Stats.INSPECT_HOPPER);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GoldenHopperBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide() ? GoldenHopperBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.GOLDEN_HOPPER.get()), HopperBlockEntity::pushItemsTick) : null;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GoldenHopperBlockEntity) {
            GoldenHopperBlockEntity hopper = (GoldenHopperBlockEntity)blockEntity;
            float strength = (float)IntStream.range(0, hopper.getContainerSize()).filter(slot -> slot != 0).mapToObj(hopper::getItem).mapToDouble(stack -> Math.clamp((double)stack.getCount() / (double)hopper.getMaxStackSize((ItemStack)stack), 0.0, 1.0)).average().orElse(0.0);
            return Mth.lerpDiscrete((float)strength, (int)0, (int)15);
        }
        return 0;
    }
}

